function [Data,File,Path,FilePath,SizeData] = ReadAscii(FilePath,String,offset,origin,DefaultPath,filterSpec,SizeData,WriteDefPathStatus,InfoDataFile)
%	ReadAscii.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.   

if nargin<9;InfoDataFile=[];end;
if nargin<8;WriteDefPathStatus=1;end;
if nargin<7;SizeData=[];end;
if nargin<6;filterSpec=[];end;
if nargin<5;DefaultPath=[];end
if nargin<4;origin=[];end
if nargin<3;offset=[];end
if nargin<2;String=[];end
if nargin<1;FilePath=[];end


if isempty(offset); offset=0; end
if isempty(origin); origin=-1; end
if isempty(filterSpec); filterSpec='*'; end
if isempty(InfoDataFile); InfoDataFile=1; end

Data=[];
File=[];
Path=[];
[DefPath]=SetDefPath(1,filterSpec);
[File,Path,FilePath]=ReadFilePath(FilePath,DefPath,String);
if WriteDefPathStatus
	SetDefPath(2,Path);
end
if File==0; Data=[]; File=[]; Path=[]; FilePath=[]; SizeData=[]; return; end
fid=fopen(FilePath,'r','b');
if fid<3
	fprintf('Can not find the file:\n\n');
	PrintFilePath(FilePath); 
	fprintf('  !!\n\n\n');
	FilePath=[];
	return;
end
if InfoDataFile
	fprintf('Start reading data from file\n\n'); 
	PrintFilePath(FilePath);
	fprintf('\n\n'); 
end
if isempty(origin); origin=-1; end
if isempty(offset); offset=0; end

fseek(fid,offset,origin);
if length(SizeData)==0
	SizeData=fscanf(fid,'%g',[1 2]);
elseif length(SizeData)==1
	[Data,Count]=fscanf(fid,'%g');
	Tmp=Count./SizeData;
	if round(Tmp)==Tmp
		SizeData(2)=Tmp;
		fseek(fid,0,-1);
	else
		Message=char('Sorry,');
		Message=char(Message,'');
		Message=char(Message,['number of values in ascii file (',int2str(Count),')']);
		Message=char(Message,['does not fit to given first matrix dimension (',int2str(SizeData),').']);
		hmsgbox=msgbox(Message,'Info','help'); 
		Data=[];
		return;
	end
end
Data=fscanf(fid,'%g',SizeData);
SizeData=size(Data);
if InfoDataFile
	fprintf('End reading data from file...\n\n'); 
end
fclose(fid);	
	
return;
