function[AvgMat,TSB,DI,SB,SC,NPoints,NChan,SampRate,TrigPoint,File,Path,FilePath,SensorNames]=ReadAsciiBesa(FilePath,filterSpec,Version);

%	ReadAsciiBesa

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.      

if nargin<3; Version=[]; end
if nargin<2; filterSpec='*.avr*'; end
if nargin<1; FilePath=[]; end

if isempty(FilePath)
	[File,Path]=uigetfile(filterSpec,'Choose Besa Ascii file:');
	FilePath=[Path,File];
else
	[File,Path]=SepFilePath(FilePath);
end

if isempty(find(FilePath)); return; end;	
if isempty(Version); Version=1; end
BESA_avr_Version=Version
fid=fopen(FilePath,'r','b');
NoUse=fscanf(fid,'%s',1);
NPoints=fscanf(fid,'%g',1);
NoUse=fscanf(fid,'%s',1);
TSB=fscanf(fid,'%g',1);
NoUse=fscanf(fid,'%s',1);
DI=fscanf(fid,'%g',1);
SampRate=1000./DI;
if Version>1
	TrigPoint=1+(-1.*TSB./DI);	
else
	TrigPoint=1+TSB./DI;
end
NoUse=fscanf(fid,'%s',1);
SB=fscanf(fid,'%g',1);
NoUse=fscanf(fid,'%s',1);
SC=fscanf(fid,'%g',1);
if Version>1;
	NoUse=fscanf(fid,'%s',1);
	NChan=fscanf(fid,'%g',1);
	SensorNames=char(fscanf(fid,'%s',1));
	if NChan>1
		for ChanInd=2:NChan
			SensorNames=char(SensorNames,fscanf(fid,'%s',1));
		end
	end
else
	SensorNames=[];
end
[AsciiVec,Count]=fscanf(fid,'%g');
if Version==1
	NChan=Count./NPoints;
	if (NChan-round(NChan))~=0
		return;
	end
end
AvgMat=(reshape(AsciiVec,NPoints,NChan))';
fclose(fid);
return;
