function[AvgMat,File,Path,FilePath,NTrialAvgVec,StdChanTimeMat,...
	SampRate,AvgRef,Version,MedMedRawVec,MedMedAvgVec,EegMegStatus,NChanExtra]=ReadAvgFile(FilePath,Version,FilterSpec);


%   ReadAvgFile.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.       

if nargin<3; FilterSpec='*.at*'; end;
if nargin<2; Version=1; end;
if nargin<1; FilePath=[]; end;

[File,Path,FilePath]=ReadFilePath(FilePath,FilterSpec,['Averaged file:'],[],[],['Please choose the\n'],['averaged file to analyse:']);
if File==0; 
   AvgMat=[];File=[];Path=[];FilePath=[];NTrialAvgVec=[];StdChanTimeMat=[];
   SampRate=[];AvgRef=[];Version=[];MedMedRawVec=[];MedMedAvgVec=[];EegMegStatus=[];NChanExtra=[];
   return; 
end
if strcmp(FilePath(length(FilePath)-2:length(FilePath)),'.ar'); AvgRef=1; else; AvgRef=0; end
	
fprintf('\n')
clc;
fprintf('Start reading data file...\n\n');
disp(FilePath); 
fprintf('\n');
fid=fopen(FilePath,'r','b');
if fid==-1; error('fopen error in ReadAvgFile.m'); end
VersionStr=fread(fid,7,'char');
VersionStr=VersionStr';
if strcmp(setstr(VersionStr),'Version')
	Version=fread(fid,1,'int16');
else
	fseek(fid,0,-1);
	Version=1;
end
if Version<4
	SizeFormat='int16';
else
	SizeFormat='float32';
end
DataFormat='float32';
if Version>2
	EegMegStatus=fread(fid,1,SizeFormat);
	NChanExtra=fread(fid,1,SizeFormat);
else
	EegMegStatus=1;
	NChanExtra=0;
end
if Version==6
    TrigPoint =  fread(fid,1,'float32');
end
[TmpSize,count]=fread(fid,2,SizeFormat);
NTotChan=TmpSize(1);
NPoints=TmpSize(2);
AvgMat=fread(fid,[NTotChan,NPoints],DataFormat);
[TmpSize,count]=fread(fid,2,SizeFormat);
TmpSize=TmpSize';
NTrialAvgVec=fread(fid,TmpSize,DataFormat);
[TmpSize,count]=fread(fid,2,SizeFormat);
TmpSize=TmpSize';
StdChanTimeMat=fread(fid,TmpSize,DataFormat);
[TmpSize,count]=fread(fid,2,SizeFormat);
TmpSize=TmpSize';
SampRate=fread(fid,TmpSize,DataFormat);
if Version>1
	[TmpSize,count]=fread(fid,2,SizeFormat);
	if isempty(TmpSize)
		MedMedRawVec=[]; 
		Version=1; 
		return; 
	end
	TmpSize=TmpSize';
	MedMedRawVec=fread(fid,TmpSize,DataFormat);
	[TmpSize,count]=fread(fid,2,SizeFormat);
	if isempty(TmpSize)
		MedMedAvgVec=[];
		Version=1; 
		return; 
	end
	TmpSize=TmpSize';
	MedMedAvgVec=fread(fid,TmpSize,DataFormat);
else
	MedMedRawVec=[];
	MedMedAvgVec=[];
end
fprintf('End reading data file...\n');
fclose(fid);
return;
