function [InFileMat,NFiles] = ReadBatchText(ReadStatus,SpecString)

%	ReadBatchText.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.          

if nargin<2; SpecString=[]; end
if nargin<1; ReadStatus=[]; end

MatlabVersionString=version;
MainMatlabVersion=str2num(MatlabVersionString(1));
if MainMatlabVersion<5; 
	fprintf(1,'Sorry, can not use ReadWriteBatchText.m with Matlab versions below Matlab5.'); 
	return;
end
InFileMat=[];
NFiles=0;

[ReadStatus]=IfEmptyInputSpecVal(ReadStatus,[1 2],1,...
'Do you want to',...
'read all lines or          [1]',...
'special masked lines       [2]');


if ReadStatus==2
	[SpecString]=IfEmptyInputString('Please choose the string to look for:',[],SpecString,'at1',1);
end

	
TotalFileIndex=0;
[File,Path]=uigetfile('*','Open text file of file names: ');
FilePath=[Path,File];
[BatchFid] = fopen(FilePath, 'r');
if BatchFid==-1; error('Bad fid in ReadBatch.m'); end
NFiles=0;
InFileMat=[];
while feof(BatchFid) == 0;
	NFiles=NFiles+1;
	TextLine=fgetl(BatchFid);
	if NFiles==1
		InFileMat=char(TextLine);
	else
		InFileMat=char(InFileMat,TextLine);
	end
end
if ReadStatus==2
	FileIndexVec=0;
	for FileIndex=1:NFiles
		s=findstr(InFileMat(FileIndex,:),SpecString);
		if ~isempty(s)
			TotalFileIndex=TotalFileIndex+1;
			FileIndexVec(TotalFileIndex)=FileIndex;
		end
	end
	if TotalFileIndex==0
		fprintf(1,'Sorry, no file with this special string found.')
		NFiles=0;
		InFileMat=[];
	else
		InFileMat=InFileMat(FileIndexVec,:);
		NFiles=length(FileIndexVec);
	end
end
if ReadStatus==3 | (ReadStatus==2 & TotalFileIndex~=0)
	fprintf(1,'Read the following %g file names:\n\n',NFiles);
	disp(InFileMat)
end
	
return;
