function [DataMat,TriMat,FilePath] = ReadBem(FilePath,chReadDataMat,BemKind,Precision,String,InfoDataMatSize,InfoDataMatFile,filterSpec,dialogTitle)


%	ReadBem.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.  

if nargin<9;dialogTitle=[];end;
if nargin<8;filterSpec='*';end;
if nargin<7;InfoDataMatFile=1;end;
if nargin<6;InfoDataMatSize=1;end;
if nargin<5;String=[];end;
if nargin<4;Precision='Ascii';end;
if nargin<3;BemKind='Matrix';end;
if nargin<2;chReadDataMat=1;end;
if nargin<1;FilePath=[];end;

if ~chReadDataMat; return; end;
if isempty(Precision); Precision=['Ascii']; end
if isempty(InfoDataMatFile); InfoDataMatFile=1; end
if isempty(InfoDataMatSize); InfoDataMatSize=1; end

DataMat=[];
TriMat=[];
	
fprintf('\n');
clc;
if isempty(String)
	[chReadDataMat]=IfEmptyInputBo(['Do you want to read the DataMat Y/N ?'],[],chReadDataMat,1);
else
	[chReadDataMat]=IfEmptyInputBo(String,['Do you want to read this DataMat Y/N ?'],chReadDataMat,1);
end
if ~chReadDataMat
	return;
end

[File,Path,FilePath]=ReadFilePath(FilePath,filterSpec,dialogTitle);


fid=fopen(FilePath,'r','b');
if fid==-1;	FilePath=0;	return; 	end
if InfoDataMatFile
	fprintf('\n');clc;
	fprintf('Start reading DataMat from file...\n\n');
  	 PrintFilePath(FilePath);
   	fprintf('\n\n');
end

if strcmp(Precision,'Ascii')	
	if strcmp(BemKind,'Inf')
		DataMat=fscanf(fid,'%g');
		return;
	end
	m=fscanf(fid,'%g',1);
	if strcmp(BemKind,'Matrix')
		n=fscanf(fid,'%g',1);
	end
else
	m=fread(fid,1,Precision);
	if strcmp(BemKind,'Matrix')
		n=fread(fid,1,Precision);
	end
end
if strcmp(BemKind,'Elektrode');
	 n=1;
elseif strcmp(BemKind,'Point') | strcmp(BemKind,'Triangle');     
	 n=4;
end
if strcmp(Precision,'Ascii')	
	DataMat=fscanf(fid,'%g',[n,m]);
else
	DataMat=fread(fid,[n,m],Precision);
end

	
if strcmp(BemKind,'Triangle')	
	if strcmp(Precision,'Ascii')	
		p=fscanf(fid,'%g',1);
		TriMat=fscanf(fid,'%g',[p,4]);
	else
		TriMat=fread(fid,[p,4],Precision);
	end
end
fprintf('End reading bem data from file...\n\n');	
fclose(fid);	
	
return;
