function[all_E_positions_spher,all_E_positions_cart,all_C_positions_cart,all_E_names,ESTATUSVEC,ECFGFILE,ESTFILE]=...
	ReadECfgStatus(path_e_config,e_config,e_status,scalp_radius,cort_radius)

%	ReadECfgStatus.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION. 

if nargin<5; cort_radius=[]; end
if nargin<4; scalp_radius=[]; end
if nargin<3; e_status=[]; end
if nargin<2; e_config=[]; end
if nargin<1; path_e_config=[]; end

global ch_config
global ch_ECFileFormat
global PATHELECTRODE
global ECFGFILE ECFGFILEPATH
global ESTFILE ESTFILEPATH
global ESTATUSVEC

[ch_ECFileFormat]=IfEmptyInputSpecVal(ch_ECFileFormat,[1 2],2,...
['Please insert the format of the electrode config file:\n'],...
['Old Cort_Map or                         [1]\n'],...
['New Cort_Map or Geo_Avg format ?        [2]']);

if ch_ECFileFormat==1 & ~isempty(e_config) & ~isempty(PATHELECTRODE);
	ECFGFILEPATH=[PATHELECTRODE,':ec_',e_config];
else
	if ch_ECFileFormat==2; filterSpec=['*ecfg']; elseif ch_ECFileFormat==1; filterSpec=['*']; end
	[ECFGFILE,PATHELECTRODE,ECFGFILEPATH]=ReadFilePath(ECFGFILEPATH,filterSpec,'Choose electrode config file:');
end
if ECFGFILE=='0'; ECFGFILE=[]; PATHELECTRODE=[]; ECFGFILEPATH=[]; ECfgFileFound=0; end
	
fid=fopen(ECFGFILEPATH,'r','b');
if fid>2; ECfgFileFound=1; else; ECfgFileFound=0; CHREADCALCAVGECFG=2; end
if ECfgFileFound
	fprintf('Start reading of file...\n\n');
	fprintf(ECFGFILEPATH)
	fprintf('\n\n');
	[all_electrodes,count] = fread(fid,1,'int16');	
	if ch_ECFileFormat==2		
		[radius,count] = fread(fid,1,'float32');
		[TmpSpher,count]= fread(fid,[all_electrodes,2],'float32');
	elseif ch_ECFileFormat==1
		radius=scalp_radius;
		[TmpSpher,count]= fread(fid,[all_electrodes,2],'float64');
	end
		
	all_E_positions_spher=zeros(all_electrodes,3);
	all_E_positions_cart=zeros(all_electrodes,3);
	all_C_positions_spher=zeros(all_electrodes,3);
	all_C_positions_cart=zeros(all_electrodes,3);
	[all_E_names,count]= fread(fid,[all_electrodes,6],'uchar');
	all_E_names=setstr(all_E_names);	
	fclose(fid);
	fprintf('End reading file...\n\n');
			
	all_E_positions_spher(:,1:2)=TmpSpher;
	all_C_positions_spher(:,1:2)=TmpSpher;
	all_E_positions_spher(:,3)=radius.*ones(all_electrodes,1);
	all_C_positions_spher(:,3)=radius.*cort_radius./scalp_radius.*ones(all_electrodes,1);	

	[m,n]=size(all_E_positions_spher);
	[all_E_positions_cart] = change_sphere_cart(all_E_positions_spher,radius,1);
	[all_C_positions_cart] = change_sphere_cart(all_E_positions_spher,radius.*cort_radius./scalp_radius,1);

else 

	fprintf('Its not possible to open the file...\n\n');
	fprintf(ECFGFILEPATH)
	fprintf('\n\n');
	error('If you use a batch file please check the electrode config name !');
end		


%=============================================================================================
%==============================READ ELECTRODE STATUS==========================================
%=============================================================================================

if ch_ECFileFormat==1
	
	if isempty(e_status)
		e_status=input('Please insert the status name of electrode configuration : ','s');
	end
	status_e_file= [PATHELECTRODE,':ec_',e_config,'_',e_status];
	fid=fopen(status_e_file,'r','b');
	if fid>2; EStFileFound=1; else; EStFileFound=0; end		
	if EStFileFound
		fprintf('Start reading of file:\n\n');
		fprintf(status_e_file);
		fprintf('\n\n');
		[ESTATUSVEC,CountNEl] = fread(fid,'int');	
		fprintf('End reading file...');
		fclose(fid);
		pause(1)
		[ESTFILE,PATHELECTRODE,ESTFILEPATH]=SaveEStatus(ESTATUSVEC,PATHELECTRODE,e_status);
	end

elseif ch_ECFileFormat==2
	
	e_status=[];e_config=[];
	ESTFILEPATH
	all_electrodes
	[ESTATUSVEC,ESTFILE,PATHELECTRODE,ESTFILEPATH,EStFileFound]=ReadEStatus(ESTFILEPATH,all_electrodes);

end

%=============================================================================================
%===============================CALC ELECTRODE STATUS=========================================
%=============================================================================================
if ~EStFileFound	
	fprintf('Start to read the status configuration:\n')
	pause(1)
	[ChanInd,NoChanInd,ESTATUSVEC]=ChooseChanInd(all_electrodes,1,1,[],[],0,all_E_positions_spher,all_E_names,[],0);
	% save ESTATUSVEC to binary file
	[ESTFILE,PATHELECTRODE,ESTFILEPATH]=SaveEStatus(ESTATUSVEC,PATHELECTRODE,e_config,e_status);
else
	if CountNEl~=all_electrodes
		fprintf('The number of electrodes in \n')
		fprintf(ESTFILEPATH)
		fprintf('does not agree with the number of electrodes in \n')
		fprintf(ECFGFILEPATH)
		error('');
	end
end
%old version
status_vec=ESTATUSVEC;
global status_vec
return;
