function[AvgMat,File,Path,FilePath,SampRate,NCells,NSubjects,...
	NPoints,NChan,NTrials,LHdr,ScaleBins,StdMat,NTrialVec]= ...
	ReadEGISAvgFile(FilePath,ReadHdrStatus,SpecCell,SpecSubject,...
	SampRate,NCells,NSubjects,NPoints,NChan,NTrials,LHdr,ScaleBins,filterSpec)

%	ReadEGISAvgFile.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.      

if nargin<13; filterSpec='*.ave*'; end;
if nargin<12; ScaleBins=[]; end;
if nargin<11; LHdr=[]; end;
if nargin<10; NTrials=[]; end;
if nargin<9; NChan=[]; end;
if nargin<8; NPoints=[]; end;
if nargin<7; NSubjects=[]; end;
if nargin<6; NCells=[]; end;
if nargin<5; SampRate=[]; end
if nargin<4; SpecSubject=1; end;
if nargin<3; SpecCell=1; end;
if nargin<2; ReadHdrStatus=1; end;
if nargin<1; FilePath=[]; end;

if ~ReadHdrStatus & (isempty(NSubjects) | isempty(NPoints) | isempty(NChan) | isempty(LHdr)  | isempty(ScaleBins))
	ReadHdrStatus=1;
end

[File,Path,FilePath]=ReadFilePath(FilePath,filterSpec,['Averaged file: (',filterSpec,')'],[],[],['Please choose the\n'],['averaged file to analyse:']);
if File==0; return; end

fprintf('\n')
clc;
fprintf('Start reading data file...\n\n');
fprintf(FilePath);
fprintf('\n\n');

fid=fopen(FilePath,'r');

BytOrd(1:4)=fread(fid,4,'int8');
HdrVer=fread(fid,1,'int16');
LHdr=fread(fid,1,'int16');
LData=fread(fid,1,'int32');
if ReadHdrStatus
	[ExptName]=fread(fid,80,'char');
	DispExptName=int2str(ExptName');

	fseek(fid,12,0); %reserved for futur use
	LastDone=fread(fid,1,'int16');
	ScaleBins=fread(fid,1,'int16');
	ScaleCal=fread(fid,1,'int16');
	BaseDur=fread(fid,1,'int16');
	fseek(fid,6,0); %reserved for futur use

	NCells=fread(fid,1,'int16');
	NChan=fread(fid,1,'int16');
	LComment=fread(fid,1,'int16');
	LText=fread(fid,1,'int16');
	LPad=fread(fid,1,'int16');
	BrdGain=fread(fid,1,'int16');
	LCellHdr=fread(fid,NCells,'int16');
	fseek(fid,4.*NChan,0); %reserved for futur use
	CellName=zeros(80,NCells);

	TrialIndex=0;
	for CellInd=1:NCells
		CellID(CellInd)=fread(fid,1,'int16');
		[CellName(:,CellInd)]=fread(fid,80,'char');
		DispCellName=int2str(CellName(:,CellInd));
		NSubjects(CellInd)=fread(fid,1,'int16');
		NPoints(CellInd)=fread(fid,1,'int16');
		SampRate(CellInd)=fread(fid,1,'int16');
		LSpec(CellInd)=fread(fid,1,'int16');
		RunDate=zeros(3,NSubjects(CellInd));
		RunTime=zeros(3,NSubjects(CellInd));
		for SubjectInd=1:NSubjects(CellInd)
			TrialIndex=TrialIndex+1;
			NTrials(TrialIndex)=fread(fid,1,'int16');
			RunDate(:,SubjectInd)=fread(fid,3,'int16');
			RunTime(:,SubjectInd)=fread(fid,3,'int16');
			SubjID(SubjectInd)=fread(fid,1,'int16');
			Handed(SubjectInd)=fread(fid,1,'int16');
			Sex(SubjectInd)=fread(fid,1,'int16');
			Age(SubjectInd)=fread(fid,1,'int16');
			ExperID(SubjectInd)=fread(fid,1,'int16');
			EdVer(SubjectInd)=fread(fid,1,'int16');
			CalFlag(SubjectInd)=fread(fid,1,'int16');
		end
	end
end

if SpecCell==0 | SpecCell==1
	NSeek=LHdr+(SpecSubject-1).*NChan.*NPoints(1).*2;
else
	NSeek=LHdr+(sum(NPoints(1:SpecCell-1).*NSubjects(1:SpecCell-1))+(SpecSubject-1).*NPoints(SpecCell)).*NChan.*2;
end
fseek(fid,NSeek,-1);
if SpecCell==0
	AvgMat=fread(fid,[NChan,sum(NPoints)],'int16');
else
	AvgMat=fread(fid,[NChan,NPoints(SpecCell)],'int16');
end
AvgMat=AvgMat./ScaleBins;

if  SpecCell==0 | SpecCell==1
	NSeek=LHdr+LData+(SpecSubject-1).*NChan.*NPoints(1).*2;
else
	NSeek=LHdr+LData+(sum(NPoints(1:SpecCell-1).*NSubjects(1:SpecCell-1))+(SpecSubject-1).*NPoints(SpecCell)).*NChan.*2;
end
SeekStatus=fseek(fid,NSeek,-1);
if SeekStatus==0
	if SpecCell==0
		StdMat=fread(fid,[NChan,sum(NPoints)],'int16');
	else
		StdMat=fread(fid,[NChan,NPoints(SpecCell)],'int16');
	end
	StdMat=StdMat./ScaleBins;
else
	StdMat=zeros(size(AvgMat));
end
if SpecCell==0 | SpecCell==1
	NSeek=LHdr+2.*LData+(SpecSubject-1).*NChan;
else
	NSeek=LHdr+2.*LData+(sum(NSubjects(1:SpecCell-1))+(SpecSubject-1)).*NChan.*2;
end
SeekStatus=fseek(fid,NSeek,-1);
if SeekStatus==0
	NTrialVec=fread(fid,NChan,'int16');
else
	NTrialVec=NTrials(sum(NSubjects(1:SpecCell-1))+SpecSubject).*ones(NChan,1);
end
fclose(fid);
return;
