function[ENames]=ReadKNEConfigFile(NrOfPolFiles,TotNrOfEl);

%	ReadKNEConfigFile.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<1; NrOfPolFiles=[]; end
[File,Path,FilePath]=ReadFilePath([],[],['Choose the Konstanz electrode config file:']);

[File,Path,FilePath]=ReadFilePath([],['Please choose the E_Config file:']);
fprintf('\n');clc;
[NrOfPolFiles]=IfEmptyInputVal(['Please insert the number of polhemus files: '],[],NrOfPolFiles,3);
fprintf('\n');clc;
[NrOfCfgRows]=IfEmptyInputVal(['Please insert the number of rows of this file: 1 or 3:'],[],[],3);
fprintf('\n');clc;
[TotNrOfEl]=IfEmptyInputVal(['Please insert the total number of electrodes:'],[],TotNrOfEl,130);


fprintf('Start to read in LOCATE.CFG file with name:\n\n')
fprintf(FilePath)
fprintf('\n\n')
fid=fopen(FilePath,'r');
[Tmp,count]=fread(fid,'char');
fprintf('End reading file.\n\n\n');
pause(1)

%+++++Reshape the electrode names
k=find(Tmp>41 & Tmp<127);
ENamesTmp=32*ones(TotNrOfEl*NrOfCfgRows,6);
ENamesTmp(1,1)=Tmp(k(1));
ElIndex=1;
NameIndex=2;
for i=2:length(k)
	if k(i)-k(i-1)==1
		ENamesTmp(ElIndex,NameIndex)=Tmp(k(i));
		NameIndex=NameIndex+1;
	else
		ElIndex=ElIndex+1; NameIndex=2;
		ENamesTmp(ElIndex,1)=Tmp(k(i));
	end
end


ENamesTmp2=ENamesTmp(1:NrOfCfgRows:TotNrOfEl*NrOfCfgRows,:);

if NrOfPolFiles>1
	ENames=zeros(TotNrOfEl*NrOfPolFiles,6);
	for i=1:NrOfPolFiles
		ENames((i-1)*TotNrOfEl+1:i*TotNrOfEl,:)=ENamesTmp2;
	end
end

ENames=setstr(ENames);

return;
