function[DataMat,DataFilePath,SetFilePath,ParaVec,MEGSensorPosMat,
        EEGSensorPosMat,MEGSensorNameVec,EEGSensorNameVec,
        MEGSensorIndexVec,EEGSensorIndexVec]=ReadMSI(DataFilePath,Trial,ReadSetStatus)
        
%	ReadMSI.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.    

if nargin<3; ReadSetStatus=1;end
if nargin<2; Trial=1;end
if nargin<1; DataFilePath=[];end

DataMat=[];
SensorPosMat=[];
ParaVec=[];
SensorNameVec=[];
SensorIndexVec=[];
File=[];
Path=[];
String='Choose MSI file:';
[DefPath]=SetDefPath(1,'*.msi');
[DataFile,DataPath,DataFilePath]=ReadFilePath(DataFilePath,DefPath,String);
SetDefPath(2,DataPath);
if DataFile==0; DataFilePath=[]; return; end

SetFile=[DataFile,'.set'];
SetFilePath=[DataPath,SetFile];
if exist(SetFilePath,'file')~=2
	Message=char('Sorry,');
	Message=char(Message,'unable to find MSI set file:');
	Message=char(Message,'');
	Message=char(Message,[SetFilePath]);
	Message=char(Message,'');
	hmsgbox=msgbox(Message,'Info','help'); 
	return;
end
[SetFilePath,ParaVec,MEGSensorPosMat,EEGSensorPosMat,MEGSensorNameVec,EEGSensorNameVec,MEGSensorIndexVec,EEGSensorIndexVec,MsiFormat]=ReadMsiSet(SetFilePath);
NTotChan=ParaVec(1);
NPoints=ParaVec(2);
NTrials=ParaVec(3);
NMegChan=ParaVec(4);
NEegChan=ParaVec(8);
SampRate=ParaVec(5);
SampPeriod=ParaVec(6);
BaseMs=ParaVec(7);

DataFid=fopen(DataFilePath,'r','b');
DataMat=fread(DataFid,[NTotChan,NPoints],MsiFormat);
fclose(DataFid);
return;
