function[FilePath,Header,LHeader,Version,Year,Month,Day,Hour,Minute,Sec,MSec, ...
	SampRate,NChan,NGain,Bits,Range,NPoints,NEvents,EventCodes]= ...
	ReadNetHeader(FilePath,chDispHeader,NetVersion,PrintStatus);
	
%   ReadNetHeader

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<4; PrintStatus = 1;end
if nargin<3; NetVersion=[]; end
if nargin<2; chDispHeader=1; end
if nargin<1; FilePath=[]; end
DefFilePath=SetDefPath(1,'*.RAW',[],0);
[File,Path,FilePath]=ReadFilePath(FilePath,DefFilePath,'Choose *.RAW file:');

if PrintStatus
	fprintf('\n');
	fprintf('Start reading NetStation file header ...\n\n');
	disp(FilePath);
	fprintf('\n\n');
end

fid=fopen(FilePath,'r','b');
Version=fread(fid,1,'long');
if ~isempty(NetVersion); 
    Version=NetVersion; 
    fprintf('Imported NetStation file version: %g\n',Version);
end
Year=fread(fid,1,'short');
Month=fread(fid,1,'short');
Day=fread(fid,1,'short');
Hour=fread(fid,1,'short');
Minute=fread(fid,1,'short');
Sec=fread(fid,1,'short');
MSec=fread(fid,1,'long');
SampRate=fread(fid,1,'short');
NChan=fread(fid,1,'short');
Gain=fread(fid,1,'short');
Bits=fread(fid,1,'short');
Range=fread(fid,1,'short');
NPoints=fread(fid,1,'long');
NEvents=fread(fid,1,'short');
EventCodes=fread(fid,[NEvents,4],'char');
Tell1=ftell(fid);
LHeader=Tell1;
fseek(fid,0,-1);
Header=fread(fid,LHeader,'int8');
if chDispHeader
	Version
	Year
	Month
	Day
	Hour
	Minute
	Sec
	MSec
	SampRate
	NChan
	Gain
	Bits
	Range
	NPoints
	NEvents
	fprintf('EventCodes = \n\n')
	disp(setstr(EventCodes'))
	LHeader
	pause(2)
end	
if PrintStatus
    fprintf('End reading NetStation RAW file header...\n');
end
return;