function Data=ReadNeuroscanTrial(FilePath,ActTrial,NsStruct,PreTrig,PostTrig,OldStatus);

%	ReadNeuroscanTrial.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.   


if nargin<6; OldStatus = 0;end
if nargin<5;PostTrig=[];end;
if nargin<4;PreTrig=[];end;
if nargin<3;NsStruct=[];end;
if nargin<2;ActTrial=1;end;
if nargin<1;FilePath=[];end;

if isempty(FilePath); Data=[]; return; end;
if isempty(NsStruct);
    if OldStatus
        NsStruct=ReadNeuroscanStructPOld(FilePath);
    else
        NsStruct=ReadNeuroscanStruct(FilePath);
    end
end
if isempty(PreTrig);PreTrig=0; end
if isempty(PostTrig);PostTrig=99; end
NsHeader=NsStruct.header;
NsEvents=NsStruct.events;
NsScale=NsHeader.scale;
NsNChan=NsHeader.nchannels;
NsPoints=NsHeader.numsamples;
DataStart=NsHeader.datastart;
DataEnd=NsHeader.eventtablepos;
NsCntType=NsHeader.continuoustype;

NPoints=PreTrig+PostTrig+1;

for i=1:NsNChan
    ChanGain(i)=NsStruct.electloc(i).sensitivity.*NsStruct.electloc(i).calib./204.8; 	%Aus BESA
end

PreTrigSeek=PreTrig.*NsNChan.*2;
if NsEvents(ActTrial).offset-PreTrigSeek<DataStart
    error('NsEvents(ActTrial).offset-PreTrigSeek<DataStart; Not enough data prior trigger');
end
NsFid=fopen(FilePath,'r','l');
FSeekStatus=fseek(NsFid,NsEvents(ActTrial).offset-PreTrigSeek,'bof');
if FSeekStatus==-1; error('fseek error; NsEvents(ActTrial).offset-PreTrigSeek'); end

if NsCntType==1

    Data=fread(NsFid,[NsNChan,NPoints],'int16');
    
elseif NsCntType==3
    
    NsChannelOffset=NsHeader.channeloffset;
    NPointsPerBlock=NsChannelOffset./2; %./2 bytes
    
    Tmp=NsEvents(ActTrial).offset-PreTrigSeek-DataStart;
    NPreChanBlocks=floor(Tmp./NsChannelOffset);
    NPrePoints=(Tmp-NPreChanBlocks.*NsChannelOffset)./2;
    NPreRestPoints=NPointsPerBlock-NPrePoints;
    
    NBlocks=floor((NPoints-NPreRestPoints)./NPointsPerBlock);
    NPostPoints=NPoints-NPreRestPoints-NBlocks.*NPointsPerBlock;
    NPostRestPoints=NPointsPerBlock-NPostPoints;

    Data=zeros(NsNChan,NPoints);
    for ChanInd=1:NsNChan
        Data(ChanInd,1:NPreRestPoints)=fread(NsFid,NPreRestPoints,'int16')';
        if ChanInd<NsNChan
            FSeekStatus=fseek(NsFid,NPrePoints.*2,'cof');
            if FSeekStatus==-1; error('fseek error; NPrePoints'); end
        end
    end
    for BlockInd=1:NBlocks
        for ChanInd=1:NsNChan
            Data(ChanInd,(BlockInd-1).*NPointsPerBlock+NPreRestPoints+1:BlockInd.*NPointsPerBlock+NPreRestPoints)=fread(NsFid,NPointsPerBlock,'int16')';
        end
    end
    for ChanInd=1:NsNChan
        Data(ChanInd,BlockInd.*NPointsPerBlock+NPreRestPoints+1:NPoints)=fread(NsFid,NPostPoints,'int16')';
        if ChanInd<NsNChan
            FSeekStatus=fseek(NsFid,NPostRestPoints.*2,'cof');
            if FSeekStatus==-1; error('fseek error; NPostRestPoints'); end
        end
    end
else
    error('Unknown NsCntType')
end
fclose(NsFid);
for i=1:NPoints
    Data(:,i)=Data(:,i).*ChanGain';
end
return;