function Data=ReadNeuroscanTrialPOld(FilePath,ActTrial,NsStruct,PreTrig,PostTrig);

%   ReadNeuroscanTrialPOld

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<5;PostTrig=[];end;
if nargin<4;PreTrig=[];end;
if nargin<3;NsStruct=[];end;
if nargin<2;ActTrial=1;end;
if nargin<1;FilePath=[];end;
	
if isempty(FilePath); Data=[]; return; end;
if isempty(NsStruct);
	NsStruct=ReadNeuroscanStruct(FilePath);
end
if isempty(PreTrig); 	
	PreTrig=0; 
end
if isempty(PostTrig); 	
	PostTrig=100; 
end
NsHeader=NsStruct.header;
NsScale=NsHeader.scale;
NsNChan=NsHeader.nchannels;
NsNPoints=PreTrig+PostTrig+1;
NsEvents=NsStruct.events;
for i=1:NsNChan
	ChanGain(i)=NsStruct.electloc(i).sensitivity.*NsStruct.electloc(i).calib./204.8; 	%Aus BESA
end
NsFid=fopen(FilePath,'r','l');
PreTrigSeek=PreTrig.*NsNChan.*2;
FSeekStatus=fseek(NsFid,NsEvents(ActTrial).offset-PreTrigSeek,'bof');
if FSeekStatus==-1
	error('fseek error in ReadNeuroscanTrial')
end
Data=fread(NsFid,[NsNChan,NsNPoints],'int16');
fclose(NsFid);
for i=1:NsNPoints
    Data(:,i)=Data(:,i).*ChanGain';
end
return;
