function[pol_data,e_names]=ReadSanDiegoPolFile(a);

%	ReadSanDiegoPolFile.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

clc;
[NrOfPolFiles]=IfEmptyInputVal(['Please insert the number of'],['Polhemus files to read in:'],[],2);
[TotNrOfEl]=IfEmptyInputVal(['Please insert the total number of electrodes:'],[],TotNrOfEl,35);
pol_data=zeros(NrOfPolFiles*TotNrOfEl,3);
e_names=zeros(NrOfPolFiles*TotNrOfEl,6);
	
for i=1:NrOfPolFiles
	%+++++Open file to read Polhemus Data
	fprintf('\n');
	clc;
	fprintf(1,'Please insert the %g file name of the original Polhemus-data:',i);
	pause(1)
	[pol_data_file,data_path]=uigetfile('*','Get File: Polhemus Data');
	pol_data_file=[data_path,pol_data_file];
	fprintf('\n')
	clc;	
	fprintf('Start to read in file with name:\n\n')
	fprintf(pol_data_file)
	fprintf('\n\n')
	fprintf('in San Diego format.')
	[fid,message]=fopen(pol_data_file,'r');

	TestChar1=[];
	TestChar2=[];
	j=0;
	
	for j=1:TotNrOfEl
		
		%============READ THE x VALUES=============
		
		while ~(TestChar1==120 & TestChar2==61)	%120 entspr.x	61 entspr. =
			[TestChar1]=fread(fid,1,'char');
			[TestChar2]=fread(fid,1,'char');
			fseek(fid,-1,'cof');
		end
		fseek(fid,1,'cof');
		[pol_data((i-1)*TotNrOfEl+j,1)]=fscanf(fid,'%g',1);
		TestChar1=[];TestChar2=[];
		
		%============READ THE y VALUES=============
		
		while ~(TestChar1==121 & TestChar2==61)	%121 entspr.y	61 entspr. =
			[TestChar1]=fread(fid,1,'char');
			[TestChar2]=fread(fid,1,'char');
			fseek(fid,-1,'cof');
		end
		fseek(fid,1,'cof');
		[pol_data((i-1)*TotNrOfEl+j,2)]=fscanf(fid,'%g',1);
		TestChar1=[];TestChar2=[];
	
		%============READ THE z VALUES=============
	
		while ~(TestChar1==122 & TestChar2==61)	%122 entspr.z	61 entspr. =
			[TestChar1]=fread(fid,1,'char');
			[TestChar2]=fread(fid,1,'char');
			fseek(fid,-1,'cof');
		end
		fseek(fid,1,'cof');
		[pol_data((i-1)*TotNrOfEl+j,3)]=fscanf(fid,'%g',1);
		TestChar1=[];TestChar2=[];
		
		%============READ THE e_names =============
		
		while ~(TestChar1==61 & TestChar2==34)	%61 entspr. =	34 entspr. "
			[TestChar1]=fread(fid,1,'char');
			[TestChar2]=fread(fid,1,'char');
			fseek(fid,-1,'cof');
		end
		fseek(fid,1,'cof');
		test=[];
		k=0;
		while test~=34
			k=k+1;
			[test]=fread(fid,1,'char');
			if test~=34
				e_names((i-1)*TotNrOfEl+j,k)=setstr(test);
			end
		end
		TestChar1=[];TestChar2=[];
	end
	fclose(fid);
end
fprintf('\n\n')
fprintf('End reading file.\n\n\n');
