function [RefFileMat]=ReformatCotFiles(CotFileMat,NewFileStatus)

%   ReformatCotFiles

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<2; NewFileStatus=[]; end
if nargin<1; CotFileMat=[]; end

if isempty(NewFileStatus); NewFileStatus=0; end
if NewFileStatus ~=1 & NewFileStatus~=0; NewFileStatus=0; end
%==================================================================
DefFileMask='*.cot';
[DefFilePath] = SetDefPath(1,DefFileMask);
[NFiles,CotFileMat,NonUse,BatchFilePath]=ReadFileNames(CotFileMat,DefFilePath,'Choose .cot files:');
[BatchFile,BatchPath]=SepFilePath(BatchFilePath);
SetDefPath(2,BatchPath);
RefFileMat=[];
for FileIndex=1:NFiles
	BadCotFormatStatus=0;
	[CotFile,CotPath,CotFilePath]=GetFileNameOfMat(CotFileMat,FileIndex);
	CotFid=fopen(CotFilePath,'r');
	CotString=fscanf(CotFid,'%s');
	fclose(CotFid);
	CotTmpVec=findstr(CotString,',');
	if length(CotTmpVec)~=2; 
		BadCotFormatStatus=1; 
	else 
		Cot(1)=str2num(CotString(1:CotTmpVec(1)-1));
		Cot(2)=str2num(CotString(CotTmpVec(1)+1:CotTmpVec(2)-1));
		Cot(3)=str2num(CotString(CotTmpVec(2)+1:length(CotString)));
		if length(Cot)~=3; 
			BadCotFormatStatus=1; 
		end
	end
	if BadCotFormatStatus
		Message=char('Sorry,  bad format of file:');
		Message=char(Message,CotFilePath);
		Message=char(Message,'');
		hWarnDlg=warndlg(Message,'Warning !');
		uiwait(hWarnDlg)
	else
		if NewFileStatus
			RefFilePath=[CotFilePath(1:length(CotFilePath)-3),'ref.cot'];
		else
			RefFilePath=CotFilePath;
		end
		if isempty(RefFileMat)
			RefFileMat=char(RefFilePath);
		else
			RefFileMat=char(RefFileMat,RefFilePath);
		end
		RefFid=fopen(RefFilePath,'w');
		fprintf(RefFid,'%s',[num2str(Cot(1)),' ',num2str(Cot(2)),' ',num2str(Cot(3)),' DC']);
		fclose(RefFid);
	end
end
