function []=ReformatStatText(FilePath,SclMnStatus)

%   ReformatStatText

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

global Data StatData AvgRunStatData

if nargin<2; SclMnStatus=[]; end
if nargin<1; FilePath=[]; end

%FilePath='Tim:Data:EEG:Bologna:00Stats:Scalp-Back-160-220.txt'
DefFilePath=SetDefPath('r','*.txt')
[File,Path,FilePath]=ReadFilePath(FilePath,DefFilePath,'Please choose a txt file:');
if File==0; return; end
if isempty(SclMnStatus)
	if strcmp(File(1:2),'MN')
		SclMnStatus=2;
	else
		SclMnStatus=1;
	end
end
if SclMnStatus==1
	NCoeff=10; %10 if Scalp, Laplace, Cort
elseif SclMnStatus==2
	NCoeff=11; %11 if Min. Norm
else
	error('Unknown SclMnStatus')
end
SclMnStatus
SetDefPath('w',Path);
fid=fopen(FilePath,'r','b');
HeaderLine=fgetl(fid);
EmptyLine=fgetl(fid);
LineInd=0;
NRow=6; %Day; Run; SensorGroup; Condition; Subject; Interval1
NDay=2
NRun=8
NGroup=4
NCond=2
SubVec=[1 3 5 6 8 9 10 12 13 14 16 17 18 19 20 21 22]
NSub=22
NInt=1
pause
NStatRow=NDay*NRun*NGroup*NCond;

while 1
	LineInd=LineInd+1;
	tline=fgetl(fid);
	if ~ischar(tline); NLine=LineInd-1; break; end
	disp(tline);  
	if LineInd==1
		Data=zeros(1,NRow);
	else
		DataNew=zeros(LineInd,NRow);
		DataNew(1:LineInd-1,:)=Data;
		Data=DataNew;
	end
	RowInd=0; 
	[Str,Remainder]=strtok(tline); 
	Sub=str2num(Str(1:2)); 
	Day=str2num(Str(4)); 
	Run=str2num(Str(6)); 
	Cond=str2num(Str(10)); 
	for i=1:NCoeff
		[Str,Remainder]=strtok(Remainder);
	end
	[Str,Remainder]=strtok(Remainder); 
	Group=str2num(Str);
	[Str,Remainder]=strtok(Remainder); 
	Int1=str2num(Str);
	Data(LineInd,:)=[Day,Run,Group,Cond,Sub,Int1];
end
fclose(fid);

% Data0=Data;
% [ValVec,IndVec]=sort(Data0(:,4)); %Sort by Cond
% Data1=Data0(IndVec,:);
% [ValVec,IndVec]=sort(Data1(:,3)); %Sort by Group
% Data2=Data1(IndVec,:);
% [ValVec,IndVec]=sort(Data2(:,2)); %Sort by Run
% Data3=Data2(IndVec,:);
% [ValVec,IndVec]=sort(Data3(:,1)); %Sort by Day
% Data4=Data3(IndVec,:);

StatData=-inf.*ones(NDay,NRun,NGroup,NCond,NSub);
for LineInd=1:NLine
	Day=Data(LineInd,1);
	Run=Data(LineInd,2);
	Group=Data(LineInd,3);
	Cond=Data(LineInd,4);
	Sub=Data(LineInd,5);
	StatData(Day,Run,Group,Cond,Sub)=Data(LineInd,6);
end

% Save StatData
fid=fopen([FilePath(1:end-3),'stv.txt'],'w','b');		
for DayInd=1:NDay
	for RunInd=1:NRun
		for GroupInd=1:NGroup
			for CondInd=1:NCond
				Str=['D',int2str(DayInd),'R',int2str(RunInd),'G',int2str(GroupInd),'C',int2str(CondInd)];
				fprintf(fid,Str);fprintf(fid,'\t');
			end
		end
	end
end
fprintf(fid,'\n');
for SubInd=1:NSub
	for DayInd=1:NDay
		for RunInd=1:NRun
			for GroupInd=1:NGroup
				for CondInd=1:NCond
					if StatData(DayInd,RunInd,GroupInd,CondInd,SubInd)>-inf
						fprintf(fid,'%g',StatData(DayInd,RunInd,GroupInd,CondInd,SubInd));
					end
					fprintf(fid,'\t');
				end
			end
		end
	end
	fprintf(fid,'\n');
end
fclose(fid);

% Average runs
AvgRunStatData=zeros(NDay,NGroup,NCond,NSub);

for SubIndTmp=1:length(SubVec)
	SubInd=SubVec(SubIndTmp);
	for DayInd=1:NDay
		for GroupInd=1:NGroup
			for CondInd=1:NCond
				IndVec=find(StatData(DayInd,:,GroupInd,CondInd,SubInd)>-inf);
				if length(IndVec)>0
					AvgRunStatData(DayInd,GroupInd,CondInd,SubInd)=mean(StatData(DayInd,IndVec,GroupInd,CondInd,SubInd));
				end
			end
		end
	end
end

% Save AvgRunStatData
fid=fopen([FilePath(1:end-3),'ar.txt'],'w','b');		
for DayInd=1:NDay
	for GroupInd=1:NGroup
		for CondInd=1:NCond
			Str=['D',int2str(DayInd),'G',int2str(GroupInd),'C',int2str(CondInd)];
			fprintf(fid,Str);fprintf(fid,'\t');
		end
	end
end
fprintf(fid,'\n');
for SubIndTmp=1:length(SubVec)
	SubInd=SubVec(SubIndTmp);
	for DayInd=1:NDay
		for GroupInd=1:NGroup
			for CondInd=1:NCond
				if AvgRunStatData(DayInd,GroupInd,CondInd,SubInd)>-inf
					fprintf(fid,'%g',AvgRunStatData(DayInd,GroupInd,CondInd,SubInd));
				end
				fprintf(fid,'\t');
			end
		end
	end
	fprintf(fid,'\n');
end
fclose(fid);

% Average days
AvgDayRunStatData=zeros(NGroup,NCond,NSub);

for SubIndTmp=1:length(SubVec)
	SubInd=SubVec(SubIndTmp);
	for GroupInd=1:NGroup
		for CondInd=1:NCond
			IndVec=find(AvgRunStatData(:,GroupInd,CondInd,SubInd)>-inf);
			if length(IndVec)>0
				AvgDayRunStatData(GroupInd,CondInd,SubInd)=mean(AvgRunStatData(IndVec,GroupInd,CondInd,SubInd));
			end
		end
	end
end

% Save AvgDayRunStatData
fid=fopen([FilePath(1:end-3),'adr.txt'],'w','b');		
for GroupInd=1:NGroup
	for CondInd=1:NCond
		Str=['G',int2str(GroupInd),'C',int2str(CondInd)];
		fprintf(fid,Str);fprintf(fid,'\t');
	end
end
fprintf(fid,'\n');
for SubIndTmp=1:length(SubVec)
	SubInd=SubVec(SubIndTmp);
	for GroupInd=1:NGroup
		for CondInd=1:NCond
			if AvgDayRunStatData(GroupInd,CondInd,SubInd)>-inf
				fprintf(fid,'%g',AvgDayRunStatData(GroupInd,CondInd,SubInd));
			end
			fprintf(fid,'\t');
		end
	end
	fprintf(fid,'\n');
end
fclose(fid);
return;

