function[AltFileMat,VersionString,BatchFilePath]=Rep2Alt(RepFileMat);
% 	function[AltFileMat,VersionString,BatchFilePath]=Rep2Alt(RepFileMat);

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer, Peter Peyk, Andreas Keil, Olaf Hauk,
%   Thomas Gruber & Andrea de Cesarei.                    
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<1; RepFileMat=[]; end

filterSpec=SetDefPath(1,'*.rep');
[NFiles,RepFileMat,VersionString,RepFilePath]=ReadFileNames(RepFileMat,filterSpec,'Please choose a *.rep batch file:')
NFiles2=floor(NFiles./2);
AltFilePath=[RepFilePath(1:end-3),'alt.rep'];
AltFileMat=char(RepFileMat(1,:));
AltFid=fopen(AltFilePath,'w','b');
for FileIndex=1:NFiles2
    fprintf(AltFid,'%s\n',RepFileMat(FileIndex,:));
    if FileIndex<NFiles2
        fprintf(AltFid,'%s\n',RepFileMat(NFiles2+FileIndex,:));
    else
        fprintf(AltFid,'%s',RepFileMat(NFiles2+FileIndex,:));
    end
    if FileIndex>1
        AltFileMat=char(AltFileMat,RepFileMat(FileIndex,:));
    end
    AltFileMat=char(AltFileMat,RepFileMat(NFiles2+FileIndex,:));
end
fclose(AltFid);
return;