function [SaveFilePath]=Save2Jmp(DataMat,FilePath,DefFileName)

%	Save2Jmp.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.    

if nargin<3;DefFileName='Untitled';end;
if nargin<2;FilePath=[];end;
if nargin<1;DataMat=[];return; end;

if isempty(FilePath)
	[File,Path,FilePath]=WriteFilePath(DefFileName,'Choose a file name:');
	if File==0; FilePath=[]; return; end
end
fid=fopen(FilePath,'w','b');
SizeDataMat=size(DataMat);
if length(SizeDataMat)>2; error('length(SizeDataMat)>2'); end
for i=1:SizeDataMat(2)
	fprintf(fid,'%g\t',DataMat(:,i));
	fprintf(fid,'\n');
end
fclose(fid);	
return;
