function[File,Path,FilePath]=SaveAvgEGISFile(FilePath,AvgMat,NTrialAvgVec,StdChanTimeMat,SampRate, ...
	BytOrd,HdrVer,LHeader,LData,ExptNam,NoUse1,NoUse2,LastDone,ScaleBins,ScaleCal,BaseDur,NoUse3,NoUse4,NoUse5, ...
	NCells,NChan,LComment,LText,LPad,BrdGain,LCellHdr)
	

%	SaveAvgEGISFile.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                  

if nargin<21; NChan=0; end
if nargin<20; NCells=0; end

if nargin<19; NoUse1=0; end
if nargin<18; NoUse1=0; end
if nargin<17; NoUse1=0; end
if nargin<16; BaseDur=0; end
if nargin<15; ScaleCal=0; end
if nargin<14; ScaleBins=0; end
if nargin<13; LastDone=0; end
if nargin<12; NoUse1=[0 0 0]; end
if nargin<11; NoUse1=[0 0 0]; end
if nargin<10; ExptNam=zeros(80,1); end
if nargin<9; LData=0; end
if nargin<8; LHeader=0; end
if nargin<7; HdrVer=0; end
if nargin<6; BytOrd=0; end
if nargin<5; SampRate=[]; end
if nargin<4; StdChanTimeMat=[]; end
if nargin<3; NTrialAvgVec=[]; end
if nargin<2; AvgMat=[]; return; end

[NChan,NPoints]=size(AvgMat);
[File,Path]=SepFilePath(FilePath);

fprintf('Start writing averaged data to file...\n\n');
fprintf(FilePath);
fprintf('\n\n');
fid=fopen(FilePath,'w');

fwrite(fid,BytOrd,'int64');
fwrite(fid,HdrVer,'int16');
fwrite(fid,LHeader,'int16');
fwrite(fid,LData,'int32');
fwrite(fid,ExptNam,'char');
fwrite(fid,NoUse1,'int16');
fwrite(fid,NoUse1,'int16');
fwrite(fid,LastDone,'int16');
fwrite(fid,ScaleBins,'int16');
fwrite(fid,ScaleCal,'int16');
fwrite(fid,BaseDur,'int16');
fwrite(fid,NoUse1,'int16');
fwrite(fid,NoUse1,'int16');
fwrite(fid,NoUse1,'int16');

fwrite(fid,NCells,'int16');




fwrite(fid,size(AvgMat),'int16');
fwrite(fid,AvgMat,'float32');
if ~isempty(NTrialAvgVec)
	fwrite(fid,size(NTrialAvgVec),'int16');
	fwrite(fid,NTrialAvgVec,'float32');
else
	fwrite(fid,[0 0],'int16');
end
if ~isempty(StdChanTimeMat)
	fwrite(fid,size(StdChanTimeMat),'int16');
	fwrite(fid,StdChanTimeMat,'float32');
else
	fwrite(fid,[0 0],'int16');
end
if ~isempty(SampRate)
	fwrite(fid,size(SampRate),'int16');
	fwrite(fid,SampRate,'float32');
else
	fwrite(fid,[0 0],'int16');
end
fprintf('End writing EGIS averaged data to file...\n');
pause(1);

fclose(fid);
return;
