function[SaveFile,SavePath,SaveFilePath]=SaveEStatus(StatusVec,PATHELECTRODE,e_config,e_status,ch_SaveEStatus);

%	SaveEStatus.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                        

if nargin<5; ch_SaveEStatus=1; end
if nargin<4; e_status=[]; end
if nargin<3; e_config=[]; end
if nargin<2; global PATHELECTRODE; end
if nargin<1; StatusVec=[]; SaveFile=[] ; SavePath=[]; SaveFilePath=[]; return; end

if strcmp(computer,'MAC2')	
   SepPathStr=':';
elseif strcmp(computer,'PCWIN')
   SepPathStr='\';
elseif strcmp(computer,'SOL2')
    SepPathStr='/';      
end;

if ~ch_SaveEStatus; SaveFile=[]; SavePath=[]; SaveFilePath=[]; return; end
[m,n]=size(StatusVec);
StatusOnVec=find(StatusVec==1);
FilterSpec=[int2str(length(StatusOnVec)) '.' int2str(m) 'est'];
if ~isempty(e_status)
	fprintf('\n');clc;fprintf('Change file name of electrode status ! (new version)'); pause(2);
	if ~isempty(PATHELECTRODE)
		SaveFilePath= [PATHELECTRODE SepPathStr e_config '.' int2str(m) 'est'];
	else
		[SaveFile,SavePath,SaveFilePath]=WriteFilePath(FilterSpec,'Save electrode status file:',...
		[],[],1,'Please save the electrode status file',['with the ending: ', FilterSpec]);
	end
else
	[SaveFile,SavePath,SaveFilePath]=WriteFilePath(FilterSpec,'Save electrode status file:',...
	[],[],1,'Please choose an electrode configuration',['with the ending: ', FilterSpec]);
end
fprintf('\n\n');
fprintf('Save electrode status to disk in file:\n');
fprintf(SaveFilePath);
fprintf('\n');
fid=fopen(SaveFilePath,'w');

count = fwrite(fid,StatusVec,'int16'); 

fclose(fid);
return;
