function [FilePath,Version]=SaveNDimData(DataMat,FilePath,Format,InitFile,DialogTitle)

%	SaveNDimData.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                 

if nargin<5;DialogTitle='Save data to file:';end;
if nargin<4;InitFile=[];end;
if nargin<3;Format='float32';end;
if nargin<2;FilePath=[];end;
if nargin<1;return;end;

if isempty(Format)
	Format='float32';
end
Version=1;
SizeDataMat=size(DataMat);
NDim=length(SizeDataMat);
fprintf(1,'\n\n')
fprintf(1,'Data size:  '); 
for i=1:NDim-1
	fprintf(1,'%g x ',SizeDataMat(i)); 
end
fprintf(1,'%g \n\n',SizeDataMat(NDim)); 
if isempty(FilePath)
    DefFilePath=SetDefPath('r','*');
	[File,Path]=uiputfile(DefFilePath,DialogTitle);
	if File==0; FilePath=[]; return; end
    SetDefPath('w',Path);
	FilePath=[Path,File];
end
fprintf('Write data to file...\n\n');
disp(FilePath)
fid=fopen(FilePath,'w','b');
fwrite(fid,Version,Format);
fwrite(fid,NDim,Format);
fwrite(fid,SizeDataMat,Format);
fwrite(fid,DataMat,Format);
fprintf(1,'\n')
fprintf('End writing data to file...\n\n');	
fclose(fid);	
return;
