function [FilePath,Version]=SaveNDimDataToRMAnova(DataMat,FilePath,Format,InitFile,DialogTitle)
%	SaveNDimDataToRMAnova.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                              

if nargin<5;DialogTitle='Save data to file:';end;
if nargin<4;InitFile=[];end;
if nargin<3;Format='float32';end;
if nargin<2;FilePath=[];end;
if nargin<1;return;end;

if isempty(Format)
	Format='float32';
end
if isempty(InitFile)
	InitFile='*.*';
end
Version=1;
SizeDataMat=size(DataMat);
NDim=length(SizeDataMat);
fprintf(1,'\n\n')
fprintf(1,'Data size:  '); 
for i=1:NDim-1
	fprintf(1,'%g x ',SizeDataMat(i)); 
end
fprintf(1,'%g \n\n',SizeDataMat(NDim)); 
if isempty(FilePath)
	[File,Path]=uiputfile(InitFile,DialogTitle);
	if File==0; FilePath=[]; return; end
	FilePath=[Path,File];
end
fprintf('Write data to file...\n\n');
disp(FilePath)
fid=fopen(FilePath,'wt','b');
fprintf(fid,'Subject\t');

if NDim==4
    %header row
    for j=1:SizeDataMat(2)
        for k=1:SizeDataMat(3)
            for l=1:SizeDataMat(4)
                fprintf(fid,['A',num2str(j),'B',num2str(k),'C',num2str(l),'\t']);
            end
        end
    end
    fprintf(fid,'\n');
    
    %nrof subjects
    for i=1:SizeDataMat(1)
        fprintf(fid,[num2str(i),'\t']);
        for j=1:SizeDataMat(2)
            for k=1:SizeDataMat(3)
                for l=1:SizeDataMat(4)
                    if j==SizeDataMat(2) & k== SizeDataMat(3) & l==SizeDataMat(4)
                       fprintf(fid,[num2str(DataMat(i,j,k,l))]);
                    else
                       fprintf(fid,[num2str(DataMat(i,j,k,l)),'\t']);
                    end
                end
            end
        end
        fprintf(fid,'\n');
        fprintf(1,'.....\n');
    end
end

if NDim==5
    %header row
    for j=1:SizeDataMat(2)
        for k=1:SizeDataMat(3)
            for l=1:SizeDataMat(4)
                for m=1:SizeDataMat(5)
                    fprintf(fid,['A',num2str(j),'B',num2str(k),'C',num2str(l),'D',num2str(m),'\t']);
                end
            end
        end
    end
    fprintf(fid,'\n');
    
    %nrof subjects
    for i=1:SizeDataMat(1)
        fprintf(fid,[num2str(i),'\t']);
        for j=1:SizeDataMat(2)
            for k=1:SizeDataMat(3)
                for l=1:SizeDataMat(4)
                    for m=1:SizeDataMat(5)
                        if j==SizeDataMat(2) & k== SizeDataMat(3) & l==SizeDataMat(4) & m==SizeDataMat(5)
                            fprintf(fid,[num2str(DataMat(i,j,k,l,m))]);
                        else
                            fprintf(fid,[num2str(DataMat(i,j,k,l,m)),'\t']);
                        end
                    end
                end
            end
        end
        fprintf(fid,'\n');
        fprintf(1,'.....\n');
    end
end

fprintf(1,'\n\n')
fprintf('End writing data to file...\n\n');	
fclose(fid);	
return;
