function [FilePath,Version]=SaveWaveletData(DataMat,FilePath,Format,InitFile,DialogTitle,SampRate,AvgRef,...
StartF0,EndF0,DeltaF0,NTap,SigmaM,EegMegStatus,NChanExtra,AmpPhaseStatus,NTrials)

%	SaveWaveletData.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.     

if nargin<16;NTrials=[];end;
if nargin<15;AmpPhaseStatus=1;end;
if nargin<14;NChanExtra=0;end;
if nargin<13;EegMegStatus=1;end;
if nargin<12;SigmaM=0;end;
if nargin<11;NTap=0;end;
if nargin<10;DeltaF0=0;end;
if nargin<9;EndF0=0;end;
if nargin<8;StartF0=0;end;
if nargin<7;AvgRef=0;end;
if nargin<6;SampRate=0;end;
if nargin<5;DialogTitle='Write data to file:';end;
if nargin<4;InitFile=[];end;
if nargin<3;Format='float32';end;
if nargin<2;FilePath=[];end;
if nargin<1;return;end;

if isempty(Format)
	Format='float32';
end
Version=3;
SizeDataMat=size(DataMat);
NDim=length(SizeDataMat);
fprintf(1,'\n\n')
fprintf(1,'Data size:  '); 
for i=1:NDim-1
	fprintf(1,'%g x ',SizeDataMat(i)); 
end
fprintf(1,'%g \n\n',SizeDataMat(NDim)); 
if isempty(FilePath)
    InitFile=SetDefPath(1,'*')
	[File,Path]=uiputfile(InitFile,DialogTitle);
	if File==0; FilePath=[]; return; end
	FilePath=[Path,File];
end
fprintf('Write Wavelet data to file...\n\n');
disp(FilePath)
fid=fopen(FilePath,'w','b');
fwrite(fid,Version,Format);
fwrite(fid,SampRate,Format);
fwrite(fid,AvgRef,Format);
fwrite(fid,StartF0,Format);
fwrite(fid,EndF0,Format);
fwrite(fid,DeltaF0,Format);
fwrite(fid,NTap,Format);
fwrite(fid,SigmaM,Format);
fwrite(fid,NDim,Format);
fwrite(fid,EegMegStatus,Format);
fwrite(fid,NChanExtra,Format);
fwrite(fid,AmpPhaseStatus,Format);
fwrite(fid,NTrials,Format);
fwrite(fid,SizeDataMat,Format);
fwrite(fid,DataMat,Format);
fprintf(1,'\n\n')
fprintf('End writing data to file...\n\n');	
fclose(fid);	
return;
