function[ENames]=SetENames(ENames,NChan,ChanStatusVec);

%	SetENames.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<3; ChanStatusVec=[]; end;
if nargin<2; NChan=[]; end;
if nargin<1; ENames=[]; end;

if ~isempty(ENames) ; return; end
if isempty(NChan); fprintf(1,'NChan==[] in SetENames'); return; end

MaxExp10=floor(log10(NChan));

ENames='      ';
for i=1:NChan
	ENames=char(ENames,AddZeros2CountStr(i,MaxExp10));
end
ENames=ENames(2:NChan+1,:);
if ~isempty(ChanStatusVec) 
	ENames=ENames(ChanStatusVec,:);
end
ENames=setstr(ENames);
return;
