function FiltData=SpatFilt(Data,PhiMat,Sigma,NormStatus)

%	SpatFilt.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<4; NormStatus=[]; end
if nargin<3
    disp('FiltData=SpatFilt(Data,PhiMat,Sigma,NormStatus)'); 
    FiltData=[]; 
    return;
end
if isempty(NormStatus);NormStatus=1; end

FiltMat=exp(-PhiMat.^2/(2*Sigma.^2));
size(Data)
size(FiltMat)
FiltData=FiltMat*Data;
if NormStatus>0
    NormVec=sqrt(sum(FiltData.^2))./sqrt(sum(Data.^2)); %GlobalPowerNormVec
    for i=1:size(Data,2)
        FiltData(:,i)=FiltData(:,i)./NormVec(i);
    end
end
return;
