function[BasePath,SepPathStr] = StartPath(file)
%	StartPath.m
%	
%	StartPath(file) looks for file in matlab path and changes 
%	directory to path of file.

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                   

if nargin<1; file='emegs2d.m'; end

% actual path
ActPath=pwd;
SepPathStr=filesep;
ActIndSepPathStr=findstr(ActPath,SepPathStr);
if strcmp(computer,'MAC2')
	ActNSepStr=length(ActIndSepPathStr)-1;
else 
	ActNSepStr=length(ActIndSepPathStr);
end;

FilePath=which(file);	%search in Matlab-Path	

if ~isempty(FilePath)
	IndSepPathStrFile=findstr(FilePath,SepPathStr);
	NSepStrFile=length(IndSepPathStrFile);
	eval(['cd(''',FilePath(1:IndSepPathStrFile(NSepStrFile)-1),''')']);
	BasePath=FilePath(1:IndSepPathStrFile(NSepStrFile));
else	
	Message=char('Sorry, the file:');
	Message=char(Message,file);
	Message=char(Message,'could not be found in the Matlab search path.');
	Message=char(Message,' ');
	Message=char(Message,'Please bring the Matlab Command window to front');
	Message=char(Message,'and use the "File:Set Path" option to modulate the search path.');
	hmsgbox=msgbox(Message,'Info','help'); 
	BasePath=[];
	return;
end;	






	

