function[OrigFileMat]=SwitchSensorsInAvgFiles(SwitchMat,InFileMat)

%	SwitchSensorsInAvgFiles.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.

if nargin<2; InFileMat=[]; end;
if nargin<1; SwitchMat=[]; end;
OrigFileMat=[];
SwitchMat=[50 51; 51 50]
if size(SwitchMat,2)~=2; fprintf(1,'size(SwitchMat,2)~=2'); return; end
NSwitch=size(SwitchMat,1)
DefFilePath=SetDefPath('r','*.at*');
[NFiles,InFileMat,NonUse,BatchFilePath]=ReadFileNames(InFileMat,DefFilePath);
if NFiles==0; return; end
[BatchFile,BatchPath]=SepFilePath(BatchFilePath);
SetDefPath('w',BatchPath);
for FileIndex=1:NFiles
	[InFile,InPath,InFilePath]=GetFileNameOfMat(InFileMat,FileIndex);
	[AvgMat,InFile,InPath,InFilePath,NTrialAvgVec,StdMat,...
	SampRate,AvgRef,Version,MedMedRawVec,MedMedAvgVec,EegMegStatus,NChanExtra]=ReadAvgFile(InFilePath);
    OrigFilePath=[InFilePath,'.orig'];
	SaveAvgFile(OrigFilePath,AvgMat,NTrialAvgVec,StdMat,SampRate,MedMedRawVec,MedMedAvgVec,EegMegStatus,NChanExtra);
	AvgMatTmp=AvgMat;
	StdMatTmp=StdMat;
    for SwitchInd=1:NSwitch
        AvgMatTmp(SwitchMat(SwitchInd,2),:)=AvgMat(SwitchMat(SwitchInd,1),:);
        StdMatTmp(SwitchMat(SwitchInd,2),:)=StdMat(SwitchMat(SwitchInd,1),:);
    end
	SaveAvgFile(InFilePath,AvgMatTmp,NTrialAvgVec,StdMatTmp,SampRate,MedMedRawVec,MedMedAvgVec,EegMegStatus,NChanExtra);
    if FileIndex==1
        OrigFileMat=char(OrigFilePath);
    else
        OrigFileMat=char(OrigFileMat,OrigFilePath);
    end
end
return;
