function[EPosSpher,ENames,NElec] = System1010(status)

%	System1010.m
%
%  	This system is based on the BESA 10/10 system

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      


if nargin<1; status=[]; end

% DEFINE ELECTRODE POSITIONS HERE

%   USING SPHERICAL COORDINATES
%
%            theta = polar (between r and z-axis with 0 < = theta <= pi )
%            phi = azimut (between the projection from r to the x,y-plan 
%   		 and x with -pi < = phi <= pi )  
%			 frontal(in y direction): 0 < phi < pi
%			 parietal(in neg. Y direction: pi < phi < 2*pi or 0 > phi > -pi
%            x = r * sin (theta) * cos (phi)
%            y = r * sin (theta) * sin (phi)
%            z = r * cos (theta)
%			 EPosSpher(ElecIndex,1:2) = [theta phi];

%			MIDLINE ELECTRODES

ElecIndex=0;

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'Nz/Nas';
EPosSpher(ElecIndex,1:2) = [112 90];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'Chin  ';
EPosSpher(ElecIndex,1:2) = [155 90];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'FPz   ';
EPosSpher(ElecIndex,1:2) = [92 90];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'FCz   ';
EPosSpher(ElecIndex,1:2) = [23 90];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'Fz    ';
EPosSpher(ElecIndex,1:2) = [45 90];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'AFz   ';
EPosSpher(ElecIndex,1:2) = [69 90];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'Cz    ';
EPosSpher(ElecIndex,1:2) = [0 0];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'CPz   ';
EPosSpher(ElecIndex,1:2) = [23 270];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'Pz    ';
EPosSpher(ElecIndex,1:2) = [45 270];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'POz   ';
EPosSpher(ElecIndex,1:2) = [69 270];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'Oz    ';
EPosSpher(ElecIndex,1:2) = [92 270];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'Iz    ';
EPosSpher(ElecIndex,1:2) = [115 270];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'Neck  ';
EPosSpher(ElecIndex,1:2) = [150 270];

%===================================

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'AF1   ';
EPosSpher(ElecIndex,1:2) = [71 102];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'AF2   ';
EPosSpher(ElecIndex,1:2) = [71 78];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'AF3   ';
EPosSpher(ElecIndex,1:2) = [74 113];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'AF4   ';
EPosSpher(ElecIndex,1:2) = [74 67];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'AF5   ';
EPosSpher(ElecIndex,1:2) = [83 121];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'AF6   ';
EPosSpher(ElecIndex,1:2) = [83 59];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'AF7   ';
EPosSpher(ElecIndex,1:2) = [92 128];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'AF8   ';
EPosSpher(ElecIndex,1:2) = [92 52];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'AF9   ';
EPosSpher(ElecIndex,1:2) = [115 133];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'AF10  ';
EPosSpher(ElecIndex,1:2) = [115 47];
 
ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'LO1   ';
EPosSpher(ElecIndex,1:2) = [118 132];
 
ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'LO2   ';
EPosSpher(ElecIndex,1:2) = [118 48];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'SO1   ';
EPosSpher(ElecIndex,1:2) = [105 115];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'SO2   ';
EPosSpher(ElecIndex,1:2) = [105 65];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'IO1   ';
EPosSpher(ElecIndex,1:2) = [125 117];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'IO2   ';
EPosSpher(ElecIndex,1:2) = [125 63];

%===================================

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'Fp1   ';
EPosSpher(ElecIndex,1:2) = [92 108];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'Fp2   ';
EPosSpher(ElecIndex,1:2) = [92 72];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'F1    ';
EPosSpher(ElecIndex,1:2) = [50 112];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'F2    ';
EPosSpher(ElecIndex,1:2) = [50 68];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'F3    ';
EPosSpher(ElecIndex,1:2) = [60 129];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'F4    ';
EPosSpher(ElecIndex,1:2) = [60 51];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'C1    ';
EPosSpher(ElecIndex,1:2) = [23 180];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'C2    ';
EPosSpher(ElecIndex,1:2) = [23 0];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'C3    ';
EPosSpher(ElecIndex,1:2) = [46 180];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'C4    ';
EPosSpher(ElecIndex,1:2) = [46 0];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'C5    ';
EPosSpher(ElecIndex,1:2) = [69 180];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'C6    ';
EPosSpher(ElecIndex,1:2) = [69 0];

%===================================

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'F5    ';
EPosSpher(ElecIndex,1:2) = [75 139];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'F6    ';
EPosSpher(ElecIndex,1:2) = [75 41];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'F7    ';
EPosSpher(ElecIndex,1:2) = [92 144];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'F8    ';
EPosSpher(ElecIndex,1:2) = [90 36];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'F9    ';
EPosSpher(ElecIndex,1:2) = [115 145];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'F10   ';
EPosSpher(ElecIndex,1:2) = [115 35];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'T7/T3 ';
EPosSpher(ElecIndex,1:2) = [92 180];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'T8/T4 ';
EPosSpher(ElecIndex,1:2) = [92 0];

%===================================

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'FT7   ';
EPosSpher(ElecIndex,1:2) = [92 162];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'FT8   ';
EPosSpher(ElecIndex,1:2) = [92 18];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'FT9   ';
EPosSpher(ElecIndex,1:2) = [115 162];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'FT10  ';
EPosSpher(ElecIndex,1:2) = [115 18];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'FC5   ';
EPosSpher(ElecIndex,1:2) = [71 159];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'FC6   ';
EPosSpher(ElecIndex,1:2) = [71 21];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'FC3   ';
EPosSpher(ElecIndex,1:2) = [50 152];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'FC4   ';
EPosSpher(ElecIndex,1:2) = [50 28];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'FC1   ';
EPosSpher(ElecIndex,1:2) = [32 135];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'FC2   ';
EPosSpher(ElecIndex,1:2) = [32 45];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'T9/LM ';
EPosSpher(ElecIndex,1:2) = [115 180];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'T10/RM';
EPosSpher(ElecIndex,1:2) = [115 0];

%===================================

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'CP1   ';
EPosSpher(ElecIndex,1:2) = [32 225];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'CP2   ';
EPosSpher(ElecIndex,1:2) = [32 315];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'CP3   ';
EPosSpher(ElecIndex,1:2) = [50 208];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'CP4   ';
EPosSpher(ElecIndex,1:2) = [50 332];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'CP5   ';
EPosSpher(ElecIndex,1:2) = [71 201];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'CP6   ';
EPosSpher(ElecIndex,1:2) = [71 339];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'TP7   ';
EPosSpher(ElecIndex,1:2) = [92 198];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'TP8   ';
EPosSpher(ElecIndex,1:2) = [92 342];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'TP9   ';
EPosSpher(ElecIndex,1:2) = [115 198];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'TP10  ';
EPosSpher(ElecIndex,1:2) = [115 342];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'P1    ';
EPosSpher(ElecIndex,1:2) = [50 248];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'P2    ';
EPosSpher(ElecIndex,1:2) = [50 292];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'P3    ';
EPosSpher(ElecIndex,1:2) = [60 231];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'P4    ';
EPosSpher(ElecIndex,1:2) = [60 309];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'P5    ';
EPosSpher(ElecIndex,1:2) = [75 221];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'P6    ';
EPosSpher(ElecIndex,1:2) = [75 319];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'P7/T5 ';
EPosSpher(ElecIndex,1:2) = [92 216];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'P8/T6 ';
EPosSpher(ElecIndex,1:2) = [92 324];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'P9    ';
EPosSpher(ElecIndex,1:2) = [115 216];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'P10   ';
EPosSpher(ElecIndex,1:2) = [115 324];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'PO1   ';
EPosSpher(ElecIndex,1:2) = [71 258];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'PO2   ';
EPosSpher(ElecIndex,1:2) = [71 282];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'PO3   ';
EPosSpher(ElecIndex,1:2) = [74 247];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'PO4   ';
EPosSpher(ElecIndex,1:2) = [74 293];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'PO5   ';
EPosSpher(ElecIndex,1:2) = [83 239];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'PO6   ';
EPosSpher(ElecIndex,1:2) = [83 301];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'PO7   ';
EPosSpher(ElecIndex,1:2) = [92 234];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'PO8   ';
EPosSpher(ElecIndex,1:2) = [92 306];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'PO9   ';
EPosSpher(ElecIndex,1:2) = [115 234];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'PO10  ';
EPosSpher(ElecIndex,1:2) = [115 306];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'O1    ';
EPosSpher(ElecIndex,1:2) = [92 252];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'O2    ';
EPosSpher(ElecIndex,1:2) = [92 288];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'O9    ';
EPosSpher(ElecIndex,1:2) = [115 252];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'O10   ';
EPosSpher(ElecIndex,1:2) = [115 288];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'CB1   ';
EPosSpher(ElecIndex,1:2) = [130 225];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'CB2   ';
EPosSpher(ElecIndex,1:2) = [130 315];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'SP1   ';
EPosSpher(ElecIndex,1:2) = [145 155];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'SP2   ';
EPosSpher(ElecIndex,1:2) = [145 25];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'M1    ';
EPosSpher(ElecIndex,1:2) = [120 205];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'M2    ';
EPosSpher(ElecIndex,1:2) = [120 335];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'A1    ';
EPosSpher(ElecIndex,1:2) = [122 184];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'A2    ';
EPosSpher(ElecIndex,1:2) = [122 356];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'T1    ';
EPosSpher(ElecIndex,1:2) = [108 160];

ElecIndex = ElecIndex+1;
ENames(ElecIndex,:) = 'T2    ';
EPosSpher(ElecIndex,1:2) = [108 20];

%===================================

EPosSpher=EPosSpher.*pi./180;

SizeEPosSpher=size(EPosSpher);
NElec=SizeEPosSpher(1);
EPosSpherTmp=zeros(NElec,3);
EPosSpherTmp(:,1:2)=EPosSpher;
EPosSpherTmp(:,3)=ones(NElec,1).*0.092;
EPosSpher=[];EPosSpher=EPosSpherTmp;EPosSpherTmp=[];
return;
