function[EPosSpher,ENames,NElec] = System1020(status)

%	System1020
%
%  	This system is based on a assumed spherical head and standart 10 - 20 system place-
% 	ment (Terrence Lagerlund et al. 1992).

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      


if nargin<1; status=[]; end

% DEFINE ELECTRODE POSITIONS HERE

%   USING SPHERICAL COORDINATES
%
%            theta = polar (between r and z-axis with 0 < = theta <= pi )
%            phi = azimut (between the projection from r to the x,y-plan 
%   		 and x with -pi < = phi <= pi )  
%			 frontal(in y direction): 0 < phi < pi
%			 parietal(in neg. Y direction: pi < phi < 2*pi or 0 > phi > -pi
%            x = r * sin (theta) * cos (phi)
%            y = r * sin (theta) * sin (phi)
%            z = r * cos (theta)
%			 EPosSpher(ElecIndex,1:2) = [theta phi];

%			MIDLINE ELECTRODES
ElecIndex = 1;
ENames(ElecIndex,:) = 'Nz    ';
EPosSpher(ElecIndex,1:2) = [112.5 90];

ElecIndex = 2;
ENames(ElecIndex,:) = 'Fpz   ';
EPosSpher(ElecIndex,1:2) = [90 90];

ElecIndex = 3;
ENames(ElecIndex,:) = 'Fz    ';
EPosSpher(ElecIndex,1:2) = [45 90];

ElecIndex = 4;
ENames(ElecIndex,:) = 'Cz    ';
EPosSpher(ElecIndex,1:2) = [0 0];

ElecIndex = 5;
ENames(ElecIndex,:) = 'Pz    ';
EPosSpher(ElecIndex,1:2) = [45 270];

ElecIndex = 6;
ENames(ElecIndex,:) = 'Oz    ';
EPosSpher(ElecIndex,1:2) = [90 270];

ElecIndex = 7;
ENames(ElecIndex,:) = 'Iz    ';
EPosSpher(ElecIndex,1:2) = [112.5 270];

%			10 % PARASAGITAL ELECTRODES

ElecIndex = 8;
ENames(ElecIndex,:) = 'Fp1   ';
EPosSpher(ElecIndex,1:2) = [90 108];

ElecIndex = 9;
ENames(ElecIndex,:) = 'Fp2   ';
EPosSpher(ElecIndex,1:2) = [90 72];

ElecIndex = 10;
ENames(ElecIndex,:) = 'O1    ';
EPosSpher(ElecIndex,1:2) = [90 252];

ElecIndex = 11;
ENames(ElecIndex,:) = 'O2    ';
EPosSpher(ElecIndex,1:2) = [90 288];

%			20 % PARASAGITAL ELECTRODES

ElecIndex = 12;
ENames(ElecIndex,:) = 'F3    ';
EPosSpher(ElecIndex,1:2) = [64 129.1];

ElecIndex = 13;
ENames(ElecIndex,:) = 'F4    ';
EPosSpher(ElecIndex,1:2) = [64 50.9];

ElecIndex = 14;
ENames(ElecIndex,:) = 'C3    ';
EPosSpher(ElecIndex,1:2) = [45 180];

ElecIndex = 15;
ENames(ElecIndex,:) = 'C4    ';
EPosSpher(ElecIndex,1:2) = [45 0];

ElecIndex = 16;
ENames(ElecIndex,:) = 'P3    ';
EPosSpher(ElecIndex,1:2) = [64 230.9];

ElecIndex = 17;
ENames(ElecIndex,:) = 'P4    ';
EPosSpher(ElecIndex,1:2) = [64 309.1];

%			40 % PARASAGITAL ELECTRODES

ElecIndex = 18;
ENames(ElecIndex,:) = 'F7    ';
EPosSpher(ElecIndex,1:2) = [90 144];

ElecIndex = 19;
ENames(ElecIndex,:) = 'F8    ';
EPosSpher(ElecIndex,1:2) = [90 36];

ElecIndex = 20;
ENames(ElecIndex,:) = 'T7    ';% == T3
EPosSpher(ElecIndex,1:2) = [90 180];

ElecIndex = 21;
ENames(ElecIndex,:) = 'T8    ';% == T4
EPosSpher(ElecIndex,1:2) = [90 0];

ElecIndex = 22;
ENames(ElecIndex,:) = 'P7    ';% == T5
EPosSpher(ElecIndex,1:2) = [90 216];

ElecIndex = 23;
ENames(ElecIndex,:) = 'P8    ';% == T6
EPosSpher(ElecIndex,1:2) = [90 324];

%			50 % PARASAGITAL ELECTRODES

ElecIndex = 24;
ENames(ElecIndex,:) = 'F9    ';
EPosSpher(ElecIndex,1:2) = [103.7 149.4];

ElecIndex = 25;
ENames(ElecIndex,:) = 'F10   ';
EPosSpher(ElecIndex,1:2) = [103.7 30.6];

ElecIndex = 26;
ENames(ElecIndex,:) = 'FT9   ';
EPosSpher(ElecIndex,1:2) = [108.7 164.3];

ElecIndex = 27;
ENames(ElecIndex,:) = 'FT10  ';
EPosSpher(ElecIndex,1:2) = [108.7 15.7];

ElecIndex = 28;
ENames(ElecIndex,:) = 'T9    ';%=A1 Mastoid left
EPosSpher(ElecIndex,1:2) = [112.5 180];

ElecIndex = 29;
ENames(ElecIndex,:) = 'T10   ';%=A2 Mastoid right
EPosSpher(ElecIndex,1:2) = [112.5 0];

ElecIndex = 30;
ENames(ElecIndex,:) = 'P9    ';
EPosSpher(ElecIndex,1:2) = [103.7 210.6];

ElecIndex = 31;
ENames(ElecIndex,:) = 'P10   ';
EPosSpher(ElecIndex,1:2) = [103.7 329.4];

%			60 % PARASAGITAL ELECTRODES

ElecIndex = 32;
ENames(ElecIndex,:) = 'TP11  ';
EPosSpher(ElecIndex,1:2) = [130.1 192.5];

ElecIndex = 33;
ENames(ElecIndex,:) = 'TP12  ';
EPosSpher(ElecIndex,1:2) = [130.1 347.5];

%EXTRA ELECTRODES

ElecIndex =34;
ENames(ElecIndex,:) = 'AF7   ';
EPosSpher(ElecIndex,1:2) = [90 126];

ElecIndex = 35;
ENames(ElecIndex,:) = 'AF8   ';
EPosSpher(ElecIndex,1:2) = [90 54];

ElecIndex = 36;
ENames(ElecIndex,:) = 'X7    ';
EPosSpher(ElecIndex,1:2) = [38.5 132.05];

ElecIndex = 37;
ENames(ElecIndex,:) = 'X8    ';
EPosSpher(ElecIndex,1:2) = [38.5 42.05];

ElecIndex = 38;
ENames(ElecIndex,:) = 'OM1   ';
EPosSpher(ElecIndex,1:2) = [112.5 240];

ElecIndex = 39;
ENames(ElecIndex,:) = 'OM2   ';
EPosSpher(ElecIndex,1:2) = [112.5 300];

%EYE ELECTRODES

ElecIndex = 40;
ENames(ElecIndex,:) = 'HE1   ';
EPosSpher(ElecIndex,1:2) = [112.5 130];

ElecIndex = 41;
ENames(ElecIndex,:) = 'HE2   ';
EPosSpher(ElecIndex,1:2) = [112.5 50];

ElecIndex = 42;
ENames(ElecIndex,:) = 'VE1   ';
EPosSpher(ElecIndex,1:2) = [107.5 108];

ElecIndex = 43;
ENames(ElecIndex,:) = 'VE2   ';
EPosSpher(ElecIndex,1:2) = [117.5 108];

EPosSpher=EPosSpher.*pi./180;

SizeEPosSpher=size(EPosSpher);
NElec=SizeEPosSpher(1);
EPosSpherTmp=zeros(NElec,3);
EPosSpherTmp(:,1:2)=EPosSpher;
EPosSpherTmp(:,3)=ones(NElec,1).*0.092;
EPosSpher=[];EPosSpher=EPosSpherTmp;EPosSpherTmp=[];
return;
