function [AlternFileMat,AlternPath] = TestFileMatWrite(FileMat,AlternPath)

%	TestFileMatWrite

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<2; AlternPath=[]; end
if nargin<1; FileMat=[]; AlternPath=[]; end

[NFiles,FileMat]=ReadFileNames(FileMat);

for FileIndex=1:NFiles;
	[File,Path,FilePath]=GetFileNameOfMat(FileMat,FileIndex);
	[TestFid,MESSAGE] = fopen([Path,'!#$'],'w');
	if TestFid~=-1;
       		fclose(TestFid);
        	delete([Path,'!#$']);
		if FileIndex==1;
			AlternFileMat=char(FilePath);
		else
			AlternFileMat=char(AlternFileMat,FilePath);
		end
	else
		if isempty(AlternPath)
               	 	while isempty(AlternPath)
                    		Message=char('It is not possible to save any data to path:');
	                	Message=char(Message,Path);
		            	Message=char(Message,'');
                   	 	Message=char(Message,'Please choose an alternative path');
                    		Message=char(Message,'in which you would like to save');
                    		Message=char(Message,'files and press "Save" !');
		            	hmsgbox=msgbox(Message,'info','help'); 
                   		[NonUse,AlternPath] = uiputfile('Test@', 'Alternative path:');
                    		close(hmsgbox)
                    		if AlternPath==0; AlternPath=[]; end
     			end
		end
		[File,Path]=SepFilePath(FilePath);
		if FileIndex==1;
			AlternFileMat=char([AlternPath,File]);
		else
			AlternFileMat=char(AlternFileMat,[AlternPath,File]);
		end
        end
end
return;
		
