function[TransFileMat,TRStatusOut]=TransCntTnt(FileMat,TRStatus,MaxMemory);

%	TransCntTnt.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<3; MaxMemory=50; end;
if nargin<2; TRStatus=[]; end;
if nargin<1; FileMat=[]; end;

[TRStatus]=IfEmptyInputSpecVal(TRStatus,[-1 1],1,...
'Please choose transform direction:\n',...
'cnt => tnt                   [ 1]',...
'tnt => cnt                   [-1]');

if TRStatus==1
	[NFiles,FileMat]=ReadFileNames(FileMat,'*.cnt','Choose Neuroscan *.cnt file(s):');
	TRStatusOut=-1;
elseif TRStatus==-1
	[NFiles,FileMat]=ReadFileNames(FileMat,'*.tnt','Choose Neuroscan *.tnt file(s):');
	TRStatusOut=1;
end
if NFiles==0; TransFileMat=[]; TRStatusOut=[]; return; end
if TRStatus==1; PutExt='tnt'; elseif TRStatus==-1; PutExt='cnt'; end
TransFileMat=FileNameExt2Mat(FileMat,PutExt,3);
	
for FileIndex=1:NFiles
	
	[File,Path,FilePath]=GetFileNameOfMat(FileMat,FileIndex);	
	NsStruct=ReadNeuroscanStruct(FilePath);
	NsHeader=NsStruct.header;
	NsEvents=NsStruct.events;		
	NChan=NsHeader.nchannels
	NPoints=NsHeader.numsamples
	DataStart=NsEvents(1).offset;
	MaxSizePoints=floor(MaxMemory.*1000000./(NChan.*2));
	NLoops=floor((NPoints./MaxSizePoints));
	RestPoints=NPoints-NLoops.*MaxSizePoints;
		
	if 	TRStatus==1			%cnt =>tnt
	
		[CntFile,CntPath,CntFilePath]=GetFileNameOfMat(FileMat,FileIndex);	
		if CntFile==0; return; end;
		[TntFile,TntPath,TntFilePath]=GetFileNameOfMat(TransFileMat,FileIndex);
		Message=char('Copying file:');
		Message=char(Message,' ');
		Message=char(Message,['Orig file: ',CntFilePath]);
		Message=char(Message,['Trans file: ',TntFilePath]);
		hmsgbox=msgbox(Message,'Info:','help');
		[CopyStatus,CopyMsg]=copyfile(CntFilePath,TntFilePath);
		if ~CopyStatus
			hmsgbox=msgbox(CopyMsg,'Info:','help');
		end
		pause(.1)
		CntFid=fopen(CntFilePath,'r','l');
		fseek(CntFid,DataStart,'bof');
		TntFid=fopen(TntFilePath,'r+','l'); 
		fseek(TntFid,DataStart,'bof');
		if NLoops==1
			fprintf('\n');
			fprintf(1,'cnt => tnt in a single loop ...\n');
			[DataMat,Count]=fread(CntFid,[NChan,NPoints],'int16');
			Count=fwrite(TntFid,DataMat','int16');
			if Count~=NChan.*NPoints; error('Count~=NChan.*NPoints in TransCntTnt'); end
		else
			for LoopInd=1:NLoops
				fprintf('\n');
				fprintf(1,'tnt => cnt\n');
				fprintf(1,'%g of %g total loops ...\n',LoopInd,NLoops);
				DataMat=fread(CntFid,[NChan,MaxSizePoints],'int16');
				SeekStatus=fseek(TntFid,DataStart+(LoopInd-1).*MaxSizePoints.*2,'bof');		
				for ChanInd=1:NChan
					fwrite(TntFid,DataMat(ChanInd,:),'int16');
				end
			end
			if RestPoints>0
				DataMat=fread(CntFid,[NChan,RestPoints],'int16');
				fseek(TntFid,DataStart+NLoops.*MaxSizePoints.*2,'bof');
				for ChanInd=1:NChan
					fwrite(TntFid,DataMat(ChanInd,:),'int16');
				end
			end
		end
		
	elseif TRStatus==-1
		
		[TntFile,TntPath,TntFilePath]=GetFileNameOfMat(FileMat,FileIndex)
		if TntFile==0; return; end;
		[CntFile,CntPath,CntFilePath]=GetFileNameOfMat(TransFileMat,FileIndex);

		Message=char('Copying file:');
		Message=char(Message,' ');
		Message=char(Message,['Orig file: ',TntFilePath]);
		Message=char(Message,['Trans file: ',CntFilePath]);
		hmsgbox=msgbox(Message,'Info:','help');
		[CopyStatus,CopyMsg]=copyfile(TntFilePath,CntFilePath);
		if ~CopyStatus
			hmsgbox=msgbox(CopyMsg,'Info:','help');
		end
		pause(.1)
		
		TntFid=fopen(TntFilePath,'r','l');
		fseek(TntFid,DataStart,'bof');
		CntFid=fopen(CntFilePath,'r+','l'); 
		fseek(CntFid,DataStart,'bof');

		if NLoops==1
			fprintf('\n');
			fprintf(1,'tnt => cnt in a single loop !\n');
			DataMat=fread(TntFid,[NPoints,NChan],'int16');
			fwrite(CntFid,DataMat','int16')
		else
			for LoopInd=1:NLoops
				fprintf('\n'); clc;
				fprintf(1,'tnt => cnt\n');
				fprintf(1,'%g of %g total loops ... \n',LoopInd+NLoops,2.*NLoops);
				DataMat=fread(TntFid,[MaxSizePoints,NChan],'int16');
				fwrite(CntFid,DataMat','int16');
			end
			if RestPoints>0
				DataMat=fread(TntFid,[RestPoints,NChan],'int16');
				fwrite(CntFid,DataMat','int16');
			end
		end
	end
	fclose(CntFid);
	fclose(TntFid);
end
return;
