function [InFileMat,NFiles,BatchFilePath] = WriteBatchFile(InFileMat,BatchFilePath)

%   WriteBatchFile

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<2; BatchFilePath=[]; end
if nargin<1; InFileMat=[]; end

MatlabVersionString=version;
MainMatlabVersion=str2num(MatlabVersionString(1));
if MainMatlabVersion<5; 
	fprintf(1,'Sorry, can not use WriteBatchFile.m with Matlab versions below Matlab5.'); 
	return;
end

FilterSpec = SetDefPath(1,[],[],0);
if nargin<2
    [NFiles,FileMatNew,VersionString,BatchFilePath]=ReadFileNames(InFileMat,FilterSpec,'Choose file names:');
else
    [NFiles,FileMatNew,VersionString,BatchFilePathTmp]=ReadFileNames(InFileMat,FilterSpec,'Choose file names:');
end
SetDefPath(2,FilterSpec,[],0);
if NFiles==0; FileMatNew=[]; BatchFilePath=[]; return; end
if isempty(BatchFilePath);
    [BatchFile,BatchPath,BatchFilePath]=WriteFilePath('*','Please name batchfile:',[],[],0,[],[],[]);
    if isequal(BatchFilePath,0)
        return
    end
end

fprintf(1,'Write file names to file:\n')
fprintf(1,'%c',BatchFilePath)
BatchFid=fopen(BatchFilePath,'w+','b');
for FileIndex=1:NFiles
	fprintf(BatchFid,'%c',[FileMatNew(FileIndex,:)]);
    fprintf(BatchFid,'\n');
end
fclose(BatchFid);
return;		
