function [InFileMat,NFiles,BatchFilePath] = WriteBatchText(SpecString)
%	WriteBatchText.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<1; SpecString=[]; end

MatlabVersionString=version;
MainMatlabVersion=str2num(MatlabVersionString(1));
if MainMatlabVersion<5; 
	fprintf(1,'Sorry, can not use ReadWriteBatchText.m with Matlab versions below Matlab5.'); 
	return;
end
InFileMat=[];
NFiles=0;

[SpecString]=IfEmptyInputString('Please choose a special string to look for:',[],SpecString,'*.at*',1);

[NFiles,InFileMat,MatlabVersionString]=ReadFileNames([],SpecString,'Choose file names:');
if NFiles==0; InFileMat=[]; BatchFilePath=[]; return; end
[BatchFile,BatchPath]=uiputfile('BatchText.txt','Choose batch file name:');
BatchFilePath=[BatchPath,BatchFile];
fprintf(1,'Write file names to file:\n\n')
fprintf(1,BatchFilePath)
BatchFid=fopen(BatchFilePath,'w+','b');
for FileIndex=1:NFiles
	fprintf(BatchFid,[InFileMat(FileIndex,:) '\n']);
end
fclose(BatchFid);
return;		
