function[File,Path,FilePath,LHeader]=WriteEGISHeader(FilePath,OpenFileStatus,PrintStatus)


%	WriteEGISHeader.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<3; PrintStatus=1; end;
if nargin<2; OpenFileStatus=0; end;
if nargin<1; FilePath=[]; end;

if isempty(FilePath)
	if OpenFileStatus==0
		[File,Path,FilePath]=WriteFilePath;
	elseif OpenFileStatus==1
		[File,Path,FilePath]=ReadFilePath;
	end
else
	[File,Path]=SepFilePath(FilePath);
end
global BytOrd
global HdrVer
global LHeader; 
global LData
global ExptNam
global RunDate
global RunTime
global SubjID
global Handed
global Sex
global Age
global ExperID
global EdVer
global CalFlag
global NCells
global NChan
global LComment
global LText
global LPad
global BrdGain
global CellID
global LCellHdr
global ChanZero
global ChanGain
global CellID
global CellName
global NTrials
global NPoints
global SampRate
global LSpec
if PrintStatus
	fprintf('Start writing header to file...\n');
	disp(FilePath);
end
if OpenFileStatus==0
	fid=fopen(FilePath,'w','b');
elseif OpenFileStatus==1
	fid=fopen(FilePath,'r+','b');
end
if fid==-1
	Message=char('Sorry,');
	Message=char(Message,'');
	Message=char(Message,'can not open EGIS file:');
	Message=char(Message,EGISFilePath);
	Message=char(Message,'to write header.');
	Message=char(Message,'(No space on drive available ?)');
	hmsgbox=msgbox(Message,'Info:','help'); 
	return;
end
CountBytOrd=fwrite(fid,BytOrd,'uint8');
CountHdrVer=fwrite(fid,HdrVer,'int16');
if isempty(LHeader); LHeader=0; end
CountLHeader=fwrite(fid,LHeader,'int16');
CountLData=fwrite(fid,LData,'int32');
CountExptNam=fwrite(fid,ExptNam,'uchar');
CountRunDate=fwrite(fid,RunDate,'int16');
CountRunTime=fwrite(fid,RunTime,'int16');
CountSubjID=fwrite(fid,SubjID,'int16');
CountHanded=fwrite(fid,Handed,'int16');
CountSex=fwrite(fid,Sex,'int16');
CountAge=fwrite(fid,Age,'int16');
CountExperID=fwrite(fid,ExperID,'int16');
CountEdVer=fwrite(fid,EdVer,'int16');
CountCalFlag=fwrite(fid,CalFlag,'int16');
CountNCells=fwrite(fid,NCells,'int16');
CountNChan=fwrite(fid,NChan,'int16');
CountLComment=fwrite(fid,LComment,'int16');
CountLText=fwrite(fid,LText,'int16');
CountLPad=fwrite(fid,LPad,'int16');
CountBrdGain=fwrite(fid,BrdGain,'int16');
CountLCellHdr=fwrite(fid,LCellHdr,'int16');
CountChanZero=fwrite(fid,ChanZero,'int16');
CountChanGain=fwrite(fid,ChanGain,'int16');
Tell1=ftell(fid);

index=0;
Offset=0;
for i=1:NCells
	if i>1
		Offset=Tell1+sum(LCellHdr(1:i-1));
		status=fseek(fid,Offset,'bof');
	end
	CountCellID(i)=fwrite(fid,CellID(i),'int16');
	CountCellName(i)=fwrite(fid,CellName(:,i),'char');
	CountNTrials(i)=fwrite(fid,NTrials(i),'int16');
	CountNPoints(i)=fwrite(fid,NPoints(i),'int16');
	CountSampRate(i)=fwrite(fid,SampRate(i),'int16');
	CountLSpec(i)=fwrite(fid,LSpec(i),'int16');
	eval(['global LSpecCell' int2str(i) ';']);
	for j=1:NTrials(i)
		eval(['tmp_vec=LSpecCell' int2str(i) '(' int2str(j) ',:);']);
		CountTmpToWrite=fwrite(fid,tmp_vec','int16');
	end
end
Tell2LHeader=ftell(fid);
if  LHeader<Tell2LHeader
	LHeader=Tell2LHeader;
    Status1=fseek(fid,0,'bof');
	Status2=fseek(fid,6,'bof');
	CountLHeader=fwrite(fid,LHeader,'int16');
end
if Tell2LHeader<LHeader
	EmptyZeros=zeros(1,LHeader-Tell2LHeader);
	CountEmpty=fwrite(fid,EmptyZeros,'int8');
end
if PrintStatus; fprintf('End writing header to file...\n'); end
TellLHeader=ftell(fid);
fclose(fid);
return;
