function [] = WriteFileMat2EGIS(FileMat,FilePath)

%	WriteFileMat2Egis.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      


if nargin<2; FilePath=[]; end
if nargin<1; FileMat=[]; end

[Header,DataFile,DataPath,DataFilePath,SampRate,NCells,NTrials,NPoints,...
NChan,LHeader,LCellHdr,BrdGain,ChanZero,ChanGain,HdrVer,Bits,Range,...
LEGISData,LSpecCellMat,BytOrd,ExptNam,RunDate,RunTime,SubjID,Handed,...
Sex,Age,ExperID,EdVer,CalFlag,LText,LComment,LPad,CellID,CellName,LSpec]=ReadEGISHeader([])

[NChan,NPoints,NTrials]=size(FileMat);
NCells=1;
NChan=31;
NCells=75;
NCond=NCells;
ConCondVec=[1:NCells];
NTrialsToAvgVec=ones(NCells,1);
NSubjects=1;
AvgLData=NPoints*NChan.*NCells.*NSubjects.*2;
AppScaleBins=100;

EgisAvgFid=fopen(FilePath,'w');

fwrite(EgisAvgFid,BytOrd,'uint8');
fwrite(EgisAvgFid,HdrVer,'int16');
TellAvgLHeader=ftell(EgisAvgFid);
AvgLHeader=1;           
fwrite(EgisAvgFid,AvgLHeader,'int16');
fwrite(EgisAvgFid,AvgLData,'int32');
fwrite(EgisAvgFid,ExptNam,'char');
fwrite(EgisAvgFid,zeros(12,1),'int8');  %reserved for futur use
fwrite(EgisAvgFid,0,'int16');           %LastDone
fwrite(EgisAvgFid,AppScaleBins,'int16');        
fwrite(EgisAvgFid,0,'int16');           %ScaleCal
fwrite(EgisAvgFid,0,'int16');           %BaseDur
fwrite(EgisAvgFid,zeros(6,1),'int8');   %reserved for futur use
       		
fwrite(EgisAvgFid,NCells,'int16');
fwrite(EgisAvgFid,NChan,'int16');
fwrite(EgisAvgFid,LComment,'int16');
fwrite(EgisAvgFid,LText,'int16');
fwrite(EgisAvgFid,LPad,'int16');
fwrite(EgisAvgFid,BrdGain,'int16');
AvgLCellHdr=zeros(NCond,1);
fwrite(EgisAvgFid,AvgLCellHdr,'int16');
fwrite(EgisAvgFid,zeros(4.*NChan,1),'int8'); %reserved for futur use

for CellInd=1:NCells
	fwrite(EgisAvgFid,ConCondVec(CellInd),'int16');	%
	fwrite(EgisAvgFid,CellName,'char');
	fwrite(EgisAvgFid,NSubjects,'int16');
	fwrite(EgisAvgFid,NPoints,'int16');
	fwrite(EgisAvgFid,SampRate,'int16');
	fwrite(EgisAvgFid,LSpec,'int16');	
    for SubjectInd=1:NSubjects
		fwrite(EgisAvgFid,NTrialsToAvgVec(CellInd),'int16');
		fwrite(EgisAvgFid,RunDate,'int16');
		fwrite(EgisAvgFid,RunTime,'int16');
		fwrite(EgisAvgFid,SubjID,'int16');
		fwrite(EgisAvgFid,Handed,'int16');
		fwrite(EgisAvgFid,Sex,'int16');
		fwrite(EgisAvgFid,Age,'int16');
		fwrite(EgisAvgFid,ExperID,'int16');
		fwrite(EgisAvgFid,EdVer,'int16');
		fwrite(EgisAvgFid,CalFlag,'int16');
	end
end
AvgLHeader=ftell(EgisAvgFid);
fseek(EgisAvgFid,TellAvgLHeader,-1);
write(EgisAvgFid,AvgLHeader,'int16');
fseek(EgisAvgFid,AvgLHeader,-1);
for CellInd=1:NCells
	fwrite(EgisAvgFid,AvgMat(:,(CellInd-1).*NPoints+1:CellInd.*NPoints).*AppScaleBins,'int16');
end
fclose(EgisAvgFid); 
return
