function[File,Path,FilePath,LHeader]=WriteNetHeader(FilePath,status)

%	WriteNetHeader.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<2; status=0; end;
if nargin<1; FilePath=[]; end;

if isempty(FilePath)
	if status==0
		[File,Path,FilePath]=WriteFilePath;
	elseif status==1
		[File,Path,FilePath]=ReadFilePath;
	end
else
	[File,Path]=SepFilePath(FilePath);
end
global Header
global LHeader
global Version
global Year
global Month
global Day
global Hour
global Minute
global Sec
global MSec
global SampRate
global NChan
global Gain
global Bits
global Range
global NPoints
global NEvents
global EventCodes

fprintf('\n')
clc;
fprintf('Start writing Net Station header to file...\n\n');
fprintf(FilePath);
fprintf('\n\n');
if status==0
	fid=fopen(FilePath,'w','b');
elseif status==1
	fid=fopen(FilePath,'r+','b');
end
CountVersion=fwrite(fid,Version,'long');
CountYear=fwrite(fid,Year,'short');
CountMonth=fwrite(fid,Month,'short');
CountDay=fwrite(fid,Day,'short');
CountHour=fwrite(fid,Hour,'short');
CountMinute=fwrite(fid,Minute,'short');
CountSec=fwrite(fid,Sec,'short');
CountMSec=fwrite(fid,MSec,'long');
CountSampRate=fwrite(fid,SampRate,'short');
CountNChan=fwrite(fid,NChan,'short');
CountGain=fwrite(fid,Gain,'short');
CountBits=fwrite(fid,Bits,'short');
CountRange=fwrite(fid,Range,'short');
CountNPoints=fwrite(fid,NPoints,'long');
CountNEvents=fwrite(fid,NEvents,'short');
CountEventCodes=fwrite(fid,EventCodes,'char');
Tell1=ftell(fid);
LHeader=Tell1;

fprintf('End writing header to file...\n');
pause(1);
fclose(fid);
return;
