function[DataOutCart]=YRotation(DataInCart,Phi,RadStatus);

%	YRotation.m


%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if nargin<3; RadStatus=0, end
[m,n]=size(DataInCart);
if n==3
	DataInCart=DataInCart';
end
if ~RadStatus
	Phi=Phi./180.*pi;
end
PhiMat=[cos(Phi) 0 sin(Phi); 0 1 0; -sin(Phi) 0 cos(Phi)];
DataOutCart=PhiMat*DataInCart;
if n==3
	DataOutCart=DataOutCart';
end
return;
