function[FigPos,AxesPos]=calc_fig_axes_cou(status,chKindData,NWin,ActWin);


%	calc_fig_axes_cou.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.  

if nargin<4; ActWin=1; end
if nargin<3; NWin=1; end

NRow=ceil(sqrt(NWin));
NCol=NRow;
ActRow=ceil(ActWin./NCol);
ActCol=ActWin-(ActRow-1).*NCol;

ColorWind=0.02;

if strcmp(computer,'MAC2')	
	if NWin==1
		FigPos=[0 0 1 1];
	else
   		FigPos=[(ActRow-1)./NRow,1-ActCol./NCol,.95/NRow,.925/NCol];
	end
elseif strcmp(computer,'PCWIN') 
	if NWin==1
		FigPos=[0 0 1 1];
	else
   		FigPos=[(ActRow-1)./NRow,1-ActCol./NCol,.95/NRow,.925/NCol];
	end
elseif strcmp(computer,'SOL2') | strcmp(computer,'LNX86') | strcmp(computer,'GLNX86')
	if NWin==1
		FigPos=[0 0 1 .92];
	else
   		FigPos=[(ActRow-1)./NRow,1-ActCol./NCol,.95/NRow,.925/NCol];
    end
end;


pos_3=calc_axes([1 1 1]);
pos_4=calc_axes([1 1 1 1]);
AxesPos=ones(14,4);


	
AxesPos(1:4:12,1)=pos_4(1,2).*ones(3,1);
AxesPos(2:4:12,1)=pos_4(2,2).*ones(3,1);
AxesPos(3:4:12,1)=pos_4(3,2).*ones(3,1);
AxesPos(4:4:12,1)=pos_4(4,2).*ones(3,1);

if status==1
	
	AxesPos(1:4,2)=pos_3(3,2).*ones(4,1);
	AxesPos(5:8,2)=pos_3(2,2).*ones(4,1);
	AxesPos(9:12,2)=pos_3(1,2).*ones(4,1);

elseif status==2
	
	AxesPos(1:4,2)=pos_3(3,2).*ones(4,1)+ColorWind;
	AxesPos(5:8,2)=pos_3(2,2).*ones(4,1)+ColorWind;
	AxesPos(9:12,2)=pos_3(1,2).*ones(4,1)+ColorWind;

end
	
AxesPos(:,3)=pos_4(1,4).*ones(14,1);
AxesPos(:,4)=pos_3(1,4).*ones(14,1);

if chKindData==1

	AxesPos(11,4)=AxesPos(11,4)./2;
	AxesPos(12,4)=AxesPos(12,4)./2;

	AxesPos(13,1)=AxesPos(11,1);
	AxesPos(13,2)=AxesPos(11,2)+4*AxesPos(11,4)./3;
	AxesPos(13,3)=AxesPos(11,3);
	AxesPos(13,4)=AxesPos(11,4)/2;

	AxesPos(14,1)=AxesPos(12,1);
	AxesPos(14,2)=AxesPos(12,2)+AxesPos(12,4);;
	AxesPos(14,3)=AxesPos(12,3);
	AxesPos(14,4)=AxesPos(12,4);

	if status==1
		AxesPos(11:14,2)=AxesPos(11:14,2)+0.025;
	else
		AxesPos(11:14,2)=AxesPos(11:14,2)-0.01;
	end

elseif chKindData==2
	AxesPos(11,1)=AxesPos(11,1)+0.035;
	AxesPos(11,3)=2*AxesPos(10,3);
	AxesPos(11,4)=AxesPos(11,4)./2;
	AxesPos(12,1)=AxesPos(11,1);
	AxesPos(12,3)=2*AxesPos(10,3);
	AxesPos(12,4)=AxesPos(11,4)./2;
	if status==1
		AxesPos(11,2)=AxesPos(11,2);
		AxesPos(12,2)=AxesPos(11,2)+3*AxesPos(10,4)/5;
	else
		AxesPos(11,2)=AxesPos(11,2)-0.01;
	end
end
AxesPos(:,2)=AxesPos(:,2)-pos_3(1,2)./2;


return;
