function [caxis_v,choice_caxis] = calc_movie_caxis(data_in,title_num)

%	calc_movie_caxis.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.        


global caxis_v total_title_num
size_data_in=size(data_in);
caxis_min=min(min(data_in));
caxis_max=max(max(data_in));
if caxis_min == caxis_max
	clc;
	fprintf('Warning:\n')
	fprintf(1,'The values of given data_in in calc_axis are all identical:  %g\n',caxis_min)
	fprintf('So I have to change the color-axis !')
	pause(2)	
	caxis_v(1,title_num)=.9*caxis_min;
	caxis_v(2,title_num)=1.1*caxis_max;
	choice_caxis==1;
else
	if size_data_in(2)>1
		clc;
		fprintf('Do you want to take for all movie pictures the same color axis [1]\n');
		fprintf('or do you want to take the best color axis for every single picture [2] ?\n');
		choice_caxis=[];
		choice_caxis=input('Please insert your choice: [1]  ');
		if isempty(choice_caxis)
			choice_caxis=1;
		end
	else
		choice_caxis=1;
	end
	
	if choice_caxis==1 
		clc;
		fprintf(1,'The values of all data to plot or surf lay between %g and %g !\n\n',caxis_min,caxis_max);
		fprintf('\n\n');
		choice_zero_center=input('Do you wish the color intervall zero centered ? Y/N [N] ?','s');
		if isempty(choice_zero_center) | choice_zero_center=='n'
			choice_zero_center='N';
		end
		if choice_zero_center~='N'
			max_abs_caxis=max(abs(caxis_min),abs(caxis_max));
			caxis_v(1,title_num)=-max_abs_caxis;
			caxis_v(2,title_num)=max_abs_caxis;
		else
			fprintf('\n\n');
			fprintf('If do you want to take this minimum value press "return"')
			caxis_min_new=input('else insert your wished value: ');
			if isempty(caxis_min_new)
				caxis_v(1,title_num)=caxis_min;
			else
				caxis_v(1,title_num)=caxis_min_new;
			end
			fprintf('\n');
			fprintf('If do you want to take this maximum value press "return"')
			caxis_max_new=input('else insert your wished value: ');
			if isempty(caxis_max_new)
				caxis_v(2,title_num)=caxis_max;
			else
				caxis_v(2,title_num)=caxis_max_new;
			end
			clc;
		end	
	end
end

return;
