function [outmat]=customcontour(inmat,levels,contourstatus,areastatus)

%   customcontour

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                        

if nargin<3;contourstatus = 1;end
if nargin<4;areastatus = 1;end
if nargin<2
    b=linspace(0,2*pi,300);
    a=meshgrid(b);
    c=a';
    d=c+a;
	e=sin(d);
	f=cos(rot90(d'));
	g=e+f;
    inmat = g;
    levels = [-2 -1.5 -1 -0.5 0 0.5 1 1.5 2];
    contourstatus = 0;
    global outmat;
end



if ~areastatus 
	%inmat nach levels angleichen
	cpyinmat = inmat;
	cmat = ones(size(inmat));
	cpyinmat(find(cpyinmat<=levels(1)))=9999991;
	for k=2:length(levels)
        cpyinmat(find(cpyinmat<=levels(k) & cpyinmat>levels(k-1)))=str2num(['999999',num2str(k)]);
	end
	
	if contourstatus == 1
		for i=1:size(inmat,1)
            for j=1:size(inmat,2)
                %upper border
                %--------------
                if i<=1 & j<=1  & i <= (size(inmat,1)-1) & j <= (size(inmat,2)-1)
                    if   cpyinmat(i,j+1)~=cpyinmat(i,j) |  cpyinmat(i+1,j)~=cpyinmat(i+1,j)  
                            cmat(i,j)=0;
                    end
                   
                elseif i>1 & j<=1 & i <= (size(inmat,1)-1) & j <= (size(inmat,2)-1)
                    if   cpyinmat(i-1,j)~=cpyinmat(i,j) | cpyinmat(i,j+1)~=cpyinmat(i,j) |  cpyinmat(i+1,j)~=cpyinmat(i+1,j)  
                            cmat(i,j)=0;
                    end
                elseif i<=1 & j>1   & i <= (size(inmat,1)-1) & j <= (size(inmat,2)-1)
                    if   cpyinmat(i,j-1)~=cpyinmat(i,j)  | cpyinmat(i,j+1)~=cpyinmat(i,j) |  cpyinmat(i+1,j)~=cpyinmat(i+1,j)  
                            cmat(i,j)=0;
                    end
                    
                %main
                %-----------------
                elseif i>1 & j>1  & i <= (size(inmat,1)-1) & j <= (size(inmat,2)-1)
		            if   cpyinmat(i,j+1)~=cpyinmat(i,j) | cpyinmat(i+1,j)~=cpyinmat(i,j)  %|cpyinmat(i+1,j+1)~=cpyinmat(i,j)
                             cmat(i,j)=0;
                    end
                
                %lower border
                %--------------   
                elseif i>1 & j>1  & i > (size(inmat,1)-2) & j <= (size(inmat,2)-1)
                   if  cpyinmat(i-1,j)~=cpyinmat(i,j)| cpyinmat(i,j-1)~=cpyinmat(i,j) | cpyinmat(i,j+1)~=cpyinmat(i,j)  
                            cmat(i,j)=0;
                   end
                elseif i>1 & j>1  & i <= (size(inmat,1)-1) & j > (size(inmat,2)-1)
                   if  cpyinmat(i-1,j)~=cpyinmat(i,j)| cpyinmat(i,j-1)~=cpyinmat(i,j) | cpyinmat(i+1,j)~=cpyinmat(i,j)  
                            cmat(i,j)=0;
                   end
                elseif i>1 & j>1 & i >(size(inmat,2)-1) & j > (size(inmat,2)-1)
                   if  cpyinmat(i-1,j)~=cpyinmat(i,j)| cpyinmat(i,j-1)~=cpyinmat(i,j)  
                            cmat(i,j)=0;
                   end
                end            
            end
		end
	end
	
	cmat1=cmat;
	cmat2=cmat;
	cmat3=cmat;
	colormat = colormap;
	for i=1:length(levels)
        cmat1(find(cpyinmat==str2num(['999999',num2str(i)])))=colormat(1+(i-1)*round(size(colormat,1)/length(levels)),1);
		cmat2(find(cpyinmat==str2num(['999999',num2str(i)])))=colormat(1+(i-1)*round(size(colormat,1)/length(levels)),2);
		cmat3(find(cpyinmat==str2num(['999999',num2str(i)])))=colormat(1+(i-1)*round(size(colormat,1)/length(levels)),3);
	end
    if contourstatus == 1
		cmat1(find(cmat==0))=0;
		cmat2(find(cmat==0))=0;
		cmat3(find(cmat==0))=0;
	end
	
	outmat=cmat1;
% 	outmat(:,:,2)=cmat2;
% 	outmat(:,:,3)=cmat3;
% 	outmat=uint8((outmat*254)+1);

else
    colormat = colormap;
    inmat=inmat-min(min(inmat));
    max(max(inmat))
    
    inmat = inmat*size(colormat,1)/max(max(inmat));
    inmat = floor(inmat);
    inmat(find(inmat==0))=1;
    outmat=inmat;
%     outmat(:,:,2)=inmat;
%     outmat(:,:,3)=inmat;
    
%     for i = 1:size(inmat,1)
%         for j =1:size(inmat,2)
%             outmat(i,j,:)=colormat(inmat(i,j),:);
%         end
%     end
% 	outmat=uint8((outmat*254)+1);
end


if nargin<1
 set(gca,'CLim',[1 30]);
% image = image(outmat,'CDataMapping','direct');
  image = pcolor(outmat);
end
if nargout<1
    outmat =[];
end
return