function [dist]=dist3d(x,y,z)

%   dist3d

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

if size(x,2)== 2 & size(y,2)==2 & size(z,2)==2
    
	diffx=abs(x(:,1)-x(:,2));
	diffy=abs(y(:,1)-y(:,2));
	diffz=abs(z(:,1)-z(:,2));
	dist=sqrt(diffx*diffx+diffy*diffy+diffz*diffz);

elseif size(x,3)== 2 & size(y,3)==2 & size(z,3)==2

	diffx=abs(x(:,:,1)-x(:,:,2));
	diffy=abs(y(:,:,1)-y(:,:,2));
	diffz=abs(z(:,:,1)-z(:,:,2));
	dist=sqrt(diffx.*diffx+diffy.*diffy+diffz.*diffz);
    
elseif size(x,3)== 1 & size(y,3)==1 & size(z,3)==1
    
    diffx=abs(x);
	diffy=abs(y);
	diffz=abs(z);
	dist=sqrt(diffx.*diffx+diffy.*diffy+diffz.*diffz);
    
else
    
    error('Inapropriate variable input size!');
end

return
