%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%
%
%   function exportsensorgroup
%
%   Andrea De Cesarei 2004
%
%
%
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



function exportsensorgroup

formatString='';

DefDataFilePath=SetDefPath('r','*.at*');
[NNetFiles,FileMat,NoUse,BatchFilePath]=ReadFileNames([],DefDataFilePath)
SetDefPath('w',BatchFilePath);
header=[];
groupDefinition=[];

SampleRate=str2num(input('\nPlease enter sample rate (default=250)','s'));

TriggerPoint=str2num(input('\nPlease enter trigger, in ms (default = 100)','s'));

SubtractBaseline=input('\nDo you want to subtract a baseline (y/n)? (default = y)','s');

WindowStart=str2num(input('\nPlease enter beginning of the window, in ms from trigger (default = 0)','s'));
WindowEnd = str2num(input('\nPlease enter ending of the window, in ms from trigger (default = 1000)','s'));

if isempty(SampleRate); SampleRate=250; end;

MsPerPoint=1000/SampleRate;

if isempty(TriggerPoint); 
    TriggerPoint=100;
end
if isempty(WindowStart); 
    WindowStart=0;
end
if isempty(WindowEnd)
    WindowEnd=1000;
end


TriggerPoint=floor(TriggerPoint/MsPerPoint);
WindowStart=floor(WindowStart/MsPerPoint)+TriggerPoint;
if WindowStart<=0; WindowStart=1; end; 
WindowEnd=floor(WindowEnd/MsPerPoint)+TriggerPoint;



[GroupFile,GroupPath,GroupFilePath]=ReadFilePath([],'*.txt','Choose a group file:');
GroupFid=fopen(GroupFilePath, 'r');
buf=fgetl(GroupFid);
i=1;
MaxGroups=0;
while ~feof(GroupFid)
    buf=fgetl(GroupFid);
    groupDefinition(i,:)=sscanf(buf, '%d')';
    if groupDefinition(i,1)>MaxGroups; MaxGroups=groupDefinition(i,1); end;
    i=i+1;
end
fclose(GroupFid);    
groupDefinition
MaxGroups
pause
Groups=[];
% for i=1:MaxGroups
%     Groups(i,:)=groupDefinition(find(groupDefinition(:,1)==i),2)';
% end


[File,Path,FilePath]=WriteFilePath('Untitled.txt','Choose a file name:');
if File==0; FilePath=[]; return; end


Fid=fopen(FilePath, 'wt');
fprintf('Start writing data file...');

 for g=1:MaxGroups
    Groups=groupDefinition(find(groupDefinition(:,1)==g),2)';
	for i=1:1:NNetFiles
        data=ReadAvgFile(FileMat(i,:));
        
        if isempty(SubtractBaseline) | SubtractBaseline=='y'
            % calc baseline for each channel
            bas=mean(data(:,1:TriggerPoint)')';
            % data=data-baseline
            for j=1:size(data,1); data(j,:)=data(j,:)-bas(j); end;
        end        
        
        %dataSel=data(Groups(g,:),WindowStart:WindowEnd);
        dataSel=data(Groups,WindowStart:WindowEnd);
        dataSelMean=mean(dataSel);
        
        if isempty(formatString)
            formatHeader='%g\t%s\t';
            dataHeader='';
            dataHeaderBean='';


            for fi=1:size(dataSelMean,2)              
                dataHeader=strcat(dataHeader,'%g\t');
            end
            formatString=strcat(formatHeader, strcat(dataHeader, '\n'));

            
        end
        

        
        
        for j=1:size(dataSelMean,1)
            fprintf(Fid, formatString, g, FileMat(i,:), dataSelMean(j,:));       
        end
        
        
        
        
	end
end

fclose(Fid);
fprintf('Writing data file finished');