function lead=lf34capr(s,d,flag,radio);

%   lf34capr
%
%   computes the vector-leadfield relating sensor s and solution point d.
%   assuming that the external radio is one,
%   in an approximate way using the one shell model 
%   using Berg parameters {EEG Journal 90 (1994) 58-64}.
%   s=(xs,ys,zs) sensor coordinates (electrode).
%   d=(xd,yd,zd) dipole coordinate or solution point.
%   lead=(lx,ly,lz) resulting components of the leadfield.
%
%   Models used
%   flag=1==> Cuffin and Cohen (1979) 4-shell model
%   flag=2==> Rush and Driscoll(1968) 3-shell model
%   flag=3==> Stok (1986) 4-shell model. Default model.
%
%   Conductivities order and radios from the outside to the inside.
%   3-shell model ==> { Scalp,Skull,Brain} 3 concentric spheres.
%   4-shell model ==> { Scalp,Skull,CSF,Brain} 4 concentric spheres.
%
%   uses lf1
%   rgpm 3-1-97.

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.  


if nargin<4,
  radio=1.0;
end;

if nargin<3,
  flag=3; % default Stok 4-shell model
end;

if flag==1, %  Cuffin and Cohen (1979) 4-shell model
  vcond=[0.33,0.0042,1.0,0.33];
  vrad=[1,0.9659,0.9205,0.8977];
  e=[-0.0729,0.6521,0.9322]'/radio;
  m=[-0.0241,0.7939,0.1935]';

elseif flag==2, %Rush and Driscoll(1968) 3-shell model    
  vcond=[0.33,0.0041,0.33]; 
  vrad=[1,0.92,0.87];
  e=[0.4407,0.7677,0.9895]'/radio;
  m=[0.428,0.2872,0.0797]';

elseif flag==3,% Stok (1986) 4-shell model.
  vcond=[0.33,0.0042,1.0,0.33];
  vrad=[1,0.9467,0.8667,0.84];
  e=[0.4191,0.7479,0.9791]'/radio;
  m=[0.4127,0.2669,0.0578]';
else
  error(' Input data error in Lf34cApr ');
end;

lead=zeros(3,1);
mm=zeros(3);
r1=d*e(1); r2=d*e(2); r3=d*e(3);

mm(:,1)=lf1(s,r1); mm(:,2)=lf1(s,r2); mm(:,3)=lf1(s,r3);
lead=mm*m;

%if flag==3,		% Empirical correction: Dipole strength 1nAm
%   lead = lead/49.8;
%end;


%over
