function[X_left_ear,Y_left_ear,Z_left_ear,...
		 X_right_ear,Y_right_ear,Z_right_ear]=model_ear(radius);

%	model_ear.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.  




ear_radius=0.3*radius;

[X_ear, Y_ear, Z_ear]=sphere(10);
X_right_ear=X_ear.*NaN;
X_left_ear=X_ear.*NaN;
Y_ear=Y_ear.*ear_radius;
Z_ear=Z_ear.*ear_radius;

for i=1:11
	for j=1:10
		if X_ear(i,j)<=0
			X_right_ear(i,j)=X_ear(i,j).*ear_radius+radius+.66.*ear_radius;
		end
		if X_ear(i,j)>=0
			X_left_ear(i,j)=X_ear(i,j).*ear_radius-radius-.66.*ear_radius;
		end
	end
end
return;



