function[DataOut,status,Minimum,Maximum]=norm_1(DataIn,status,Statusdef,Minimum,Maximum,MatStatus,MatStatusDef);

%	norm_1(DataIn,status,Statusdef,Minimum,Maximum,MatStatus,MatStatusDef);
%
%	This function normalizes a matrix DataIn:
%	If status==1 with 0<=x<=1%	
%	If status==2 with -1<=x<=1%	
%	If status==3 with mean=0 and stdv=1%
%	If status==4 with Minimum<=x<=Maximum


%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.  
if nargin<7; MatStatusDef=[]; end
if nargin<6; MatStatus=1; end
if nargin<5; Maximum=[]; end
if nargin<4; Minimum=[]; end
if nargin<3; Statusdef=[]; end
if nargin<2; status=[]; end

[status]=IfEmptyInputSpecVal( status, [0:6] , Statusdef,...
['Please insert the kind of normalization:\n\n'],...
['Root Mean Square        [0]'],...
['0  <= x <=  1           [1]'],...
['-1 <= x <=  1           [2]'],...
['z ; mean=0 & std=1      [3]'],...
['between Min and Max     [4]'],...
['natural log             [5]'],...
['base 10 log             [6]'],...
['square root             [7]']);

if isempty(DataIn); fprintf('Matrix DataIn in norm_1 is empty !'); pause(1); return; end

[m,n]=size(DataIn);

if n==1; fprintf(1,'Bad size of matrix DataIn in norm_1 !'); pause(1); return; end
if m>1 & n>1
	[MatStatus]=IfEmptyInputSpecVal(MatStatus,[1:3],MatStatusDef,...
	'Please insert the kind of normalization:\n\n',...
	'per row        [1]',...
	'per column     [2]',...
	'per matrix     [3]');
else
	MatStatus=1;
end
if status==4
	if (isempty(Minimum)) | (isempty(Maximum)) | (Maximum<=Minimum)
		while Maximum<=Minimum
			[Minimum]=IfEmptyInputVal(['Please insert the minimum'],['of the vector or matrix to normalize:'],[],-1,1);
			[Maximum]=IfEmptyInputVal(['Please insert the maximum'],['of the vector or matrix to normalize:'],[],1,0);
		end
	end
end
if MatStatus==2;
    DataOut=zeros(n,m);
else
    DataOut=zeros(m,n);
end
if status==4
	MinMaxFactor=Maximum-Minimum;
	if MatStatus==1 
		MinimumVec=Minimum.*ones(1,n);
	elseif MatStatus==2 
		MinimumVec=Minimum.*ones(1,m);
	elseif MatStatus==3
		MinimumMat=Minimum.*ones(m,n);
	end
end
if MatStatus==1 |  MatStatus==2
	if MatStatus==2; DataIn=DataIn'; nTmp=n; mTmp=m; m=nTmp; n=mTmp; end
	for i=1:m
		if ~all(DataIn(i,:)==DataIn(i,1))
            if status==0
				DataOut(i,:)=DataIn(i,:)./sqrt(sum(DataIn(i,:).^2));
            elseif status==1
				DataOut(i,:)=DataIn(i,:)-min(DataIn(i,:));
				DataOut(i,:)=DataOut(i,:)./max(DataOut(i,:));
			elseif status==2
				DataOut(i,:)=DataIn(i,:)-min(DataIn(i,:));
				DataOut(i,:)=(DataOut(i,:)./(max(DataOut(i,:))./2))-1;
			elseif status==3
				mean_data=mean(DataIn(i,:));
				DataOut(i,:)=DataIn(i,:)-mean_data;
				std_data=std(DataOut(i,:));
				DataOut(i,:)=DataOut(i,:)./std_data;
			elseif status==4
				DataOut(i,:)=DataIn(i,:)-min(DataIn(i,:));
				DataOut(i,:)=DataOut(i,:)./max(DataOut(i,:));
				DataOut(i,:)=(MinMaxFactor.*DataOut(i,:))+MinimumVec;
            elseif status==5 | status==6 | status==7
                DataInVec=DataIn(i,:);
                NegVec=find(DataInVec<0);
                if status==5
                    DataInVec=log(abs(DataInVec)+ones(size(DataInVec)));
                elseif status==6
                    DataInVec=log10(abs(DataInVec)+ones(size(DataInVec)));
                elseif status==7
                    DataInVec=sqrt(abs(DataInVec));
                end
                DataInVec(NegVec)=-1.*DataInVec(NegVec);
				DataOut(i,:)=DataInVec;
			end
		else
			DataOut(i,:)=DataIn(i,:);
		end
	end
	if MatStatus==2; DataOut=DataOut'; end
elseif MatStatus==3
    if status==0
	    DataOut=DataIn./sqrt(sum(DataIn.^2));
    elseif status==1
		DataOut=DataIn-min(min(DataIn));
		DataOut=DataOut./max(max(DataOut));
	elseif status==2
		DataOut=DataIn-min(min(DataIn));
		DataOut=(DataOut./(max(max(DataOut))./2))-1;
	elseif status==3
		fprintf('Warning in norm_1.m; This normalization is not permitted\n')
		DataOut=DataIn;
	elseif status==4
		DataOut=DataIn-min(min(DataIn));
		DataOut=DataOut./max(max(DataOut));
		DataOut=(MinMaxFactor.*DataOut)+MinimumMat;
     elseif status==5 | status==6 | status==7
        NegMat=find(DataIn<0);
        if status==5
            DataOut=log(abs(DataIn)+ones(size(DataIn)));
        elseif status==6
            DataOut=log10(abs(DataIn)+ones(size(DataIn)));
        elseif status==7
            DataOut=sqrt(abs(DataIn));
        end
        DataOut(NegMat)=-1.*DataOut(NegMat);
	end
end
return;
