function okanovadesign

%   okanovadesign

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Andreas Keil, Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.    


anovadesignfig = findobj('tag','anovadesignfig');
pointwisecheck = findobj('tag','pointwisecheck');
intervallsedit=findobj('tag','intervallsedit');
channelgroupsedit=findobj('tag','channelgroupsedit');
f4nameedit= findobj('tag','f4nameedit');
nrofsubjectsedit = findobj('tag','nrofsubjectsedit');
f4gradedit= findobj('tag','f4gradedit');
f3nameedit= findobj('tag','f3nameedit');
f3gradedit=findobj('tag','f3gradedit');
f2nameedit= findobj('tag','f2nameedit');
f2gradedit=findobj('tag','f2gradedit');
f1nameedit= findobj('tag','f1nameedit');
f1gradedit= findobj('tag','f1gradedit');
bf1nameedit= findobj('tag','bf1nameedit');
bf1gradedit= findobj('tag','bf1gradedit');
bf1subjectcelledit=findobj('tag','bf1subjectcelledit');
bf1check=findobj('tag','bf1check');
f4check= findobj('tag','f4check');
f3check= findobj('tag','f3check');
f2check= findobj('tag','f2check');
f1check= findobj('tag','f1check');
cancelbutton = findobj('tag','cancelbutton');
okbutton= findobj('tag','okbutton');


                        
% factor =          1           2           3   
%           1       nsubj       ninterv     nchgroups
%           2       target      nbetween    nsubjlistcells
%           3       custom1     c1ngrad     c1gradnames
%           4       custom2     c2ngrad     c2gradnames
%           5       custom3     c3ngrad     c3gradnames
%           6       custom4     c4ngrad     c4gradnames


factor = cell(1);
factor{1,1} = str2num(get(nrofsubjectsedit,'String'));
if isempty(factor{1,1}) | factor{1,1}<2
    uiwait(errordlg('Not enough subjects for analysis!'));
    return
end
factor{1,2} = str2num(get(intervallsedit,'String'));
factor{1,3} = str2num(get(channelgroupsedit,'String'));
if get(pointwisecheck,'Value')==1
    factor{2,1} = 'target 1;';
else
    factor{2,1} = 'no target';
end
if get(bf1check,'Value')==1
    factor{2,2} = 1;
    factor{2,3} = str2num(get(bf1subjectcelledit,'String'));
else
    factor{2,2} = 0;
    factor{2,3} = '';
end
if get(f1check,'Value')==1
    factor{3,1} = get(f1nameedit,'String');
    factor{3,2} = str2num(get(f1gradedit,'String'));
end
if get(f2check,'Value')==1
    factor{4,1} = get(f2nameedit,'String');
    factor{4,2} = str2num(get(f2gradedit,'String'));
end
if get(f3check,'Value')==1
    factor{5,1} = get(f3nameedit,'String');
    factor{5,2} = str2num(get(f3gradedit,'String'));
end
if get(f4check,'Value')==1
    factor{6,1} = get(f4nameedit,'String');
    factor{6,2} = str2num(get(f4gradedit,'String'));
end
nrofwithinfactors = size(factor,1)-2;
if get(bf1check,'Value')==1
    factor{nrofwithinfactors+3,1} = get(bf1nameedit,'String');
    factor{nrofwithinfactors+3,2} = str2num(get(bf1gradedit,'String'));
end


if size(factor,1)<2
    uiwait(errordlg('Please correct the design!','Error in anova-definition:'));
    return
end


global hPlot3dMenuFig;
hPlot3dList=get(hPlot3dMenuFig,'Userdata');
set(hPlot3dList(131),'userdata',factor);
close(anovadesignfig);
    
   

return