function [] = plot_EC_positions(status,dim,status_text,ForeGroundColor,ch_PlotECPositions)

%	plot_EC_positions.m
%	This will plot the cartesian Electrode positions in an 2 or 3 dimensional plot
%	Status==1 => Scalp
%	Status==2 => Cortex

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.  

if nargin<5; ch_PlotECPositions=1; end;
if nargin<4; ForeGroundColor='k'; end;
if ~ch_PlotECPositions; return; end;

%________PLOT ELECTODE POSITIONS 
global total_electrodes 
global E_positions_cart C_positions_cart 
global scalp_radius cort_radius

if status==1
	radius=scalp_radius;
	EC_positions_cart=E_positions_cart;
elseif status==2
	radius=cort_radius;
	EC_positions_cart=C_positions_cart;
end
faktor_ro=1.035;
PlotKind=[ForeGroundColor,'o'];
if dim==2
	for j=1:total_electrodes
		plot(EC_positions_cart(j,1),EC_positions_cart(j,2),PlotKind);	
	end
	hold on
	if status_text==1
		text(1.05*radius,0, 'RPA','FontSize',[16],'Color',ForeGroundColor);
		text(0.05*radius,0, 'Cz','FontSize',[16],'Color',ForeGroundColor);
		text(-1.1*radius,0, 'LPA','FontSize',[16],'Color',ForeGroundColor);
		text(0,-1.05*radius, 'Iz','FontSize',[16],'Color',ForeGroundColor);
	end
elseif dim==3
	for j=1:total_electrodes
		plot3(faktor_ro.*EC_positions_cart(j,1),faktor_ro.*EC_positions_cart(j,2),faktor_ro.*EC_positions_cart(j,3),PlotKind);
		hold on	
	end	
	if status_text==1
		text(1.15*radius,0,0, 'RPA','HorizontalAlignment','center','FontSize',[16],'Color',ForeGroundColor);
		text(0,0,1.15*radius, 'Cz','HorizontalAlignment','center','FontSize',[16],'Color',ForeGroundColor);
		text(-1.15*radius,0,0, 'LPA','HorizontalAlignment','center','FontSize',[16],'Color',ForeGroundColor);
		text(0,1.15*radius,0, 'Nz','HorizontalAlignment','center','FontSize',[16],'Color',ForeGroundColor);
		text(0,-1.15*radius,0, 'Iz','HorizontalAlignment','center','FontSize',[16],'Color',ForeGroundColor);
		hold on
	end
else
	error('Bad dimension')
end
return;
