function[]=plot_head_contour(AxesPos,status,chSpecView,ForeGroundColor,chPlotHeadCont)


%	plot_head_contour.m

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.        

if nargin<5; chPlotHeadCont=1; end;
if nargin<4; ForeGroundColor=[0 0 0]; end;

if ~chPlotHeadCont; return; end;
if ForeGroundColor==[0 0 0]; ColorString='k';
else ColorString='o';
end
LineWidth=1.5;

haxes=axes('Units','normal','Position',AxesPos,'NextPlot','add');
ln_x=[0.0676 0.0946 0.1081 0.1216 0.12];
n_y=[0.3395 0.2698 0.2047 0.1395 0.06];
rn_x=ones(size(ln_x))-ln_x;
re_x=[0.9369 0.9459 0.9505 0.9550 0.9640 0.9775 0.9955 1.0000 1.0035 1.0035 1.0000 0.998 ...
 0.9955 0.9910 0.9910 0.9955 0.9955 0.9910 0.9820 0.9730 0.9640 0.9550 0.9414 0.9324 0.9234 0.9369];
e_y= [0.3674 0.4000 0.4279 0.4698 0.4837 0.4884 0.4884 0.4837 0.4744 0.4698 0.4651 0.4465...
  0.4233 0.3953 0.3674 0.3395 0.3116 0.2977 0.2884 0.2837 0.2837 0.2884 0.2977 0.3070 0.3163 0.3674];
le_x=ones(size(re_x))-re_x;	
rte_x=[0.9550 0.9730 0.9865 0.9955 0.9955 0.9955 0.9910 0.9910 0.9955 0.9955 1.0000 1.0000 0.9955 ...
   0.9865 0.9820 0.9730 0.9640 0.9595 0.9550 0.9550 0.9550 0.9550];
lte_x=ones(size(rte_x))-rte_x;	
te_y=[0.5209 0.5349 0.5349 0.5256 0.5116 0.4977 0.4791 0.4558 0.4372 0.4233 0.4093 0.3907 0.3814 ...
  0.3767 0.3767 0.3814 0.3907 0.4047 0.4372 0.4605  0.4930 0.5209];
lnose_x=[0.0465 0.0586 0 0.0045 0.0180 0.0315 0.0450 0.0541 0.0631 0.0721 0.0766];
nose_y=[0.4263 0.3628 0.2140 0.2186 0.2047 0.1953 0.1814 0.1674 0.1488 0.1256 0.0884];
rnose_x=ones(size(lnose_x))-lnose_x;	
tnose_x=[0.3722 0.4099 0.5 0.5919];
tnose_y=[0.9414 0.9488 1 0.9502];
if status==2
	x=linspace(-pi,pi,40);
	scalp_x=0.4595.*cos(x)+0.5;
	scalp_y=0.4595.*sin(x)+0.5;
end	
if chSpecView==1 | chSpecView==2
	hPlot=plot(ln_x,n_y,ColorString);
	set(hPlot,'LineWidth',LineWidth)
	axis([0 1 0 1])
	axis('off')
	hold on
	hPlot=plot(rn_x,n_y,ColorString);
	set(hPlot,'LineWidth',LineWidth)
	axis([0 1 0 1])
	axis('off')
	hold on
	hPlot=plot(le_x,e_y,ColorString);
	set(hPlot,'LineWidth',LineWidth)
	axis([0 1 0 1])
	axis('off')
	hold on
	hPlot=plot(re_x,e_y,ColorString);
	set(hPlot,'LineWidth',LineWidth)
	axis([0 1 0 1])
	axis('off')
	hold on
	if status==2
		hPlot=plot(scalp_x(20:40),scalp_y(20:40),ColorString);
		set(hPlot,'LineWidth',LineWidth)
		hold on
		hPlot=plot(scalp_x(1:2),scalp_y(1:2),ColorString);
		set(hPlot,'LineWidth',LineWidth)
		axis('off')
		hold on
	end

elseif chSpecView==3 | chSpecView==4

	hPlot=plot(lte_x,te_y,ColorString);
	set(hPlot,'LineWidth',LineWidth)
	axis([0 1 0 1])
	axis('off')
	hold on
	hPlot=plot(rte_x,te_y,ColorString);
	set(hPlot,'LineWidth',LineWidth)
	axis([0 1 0 1])
	axis('off')
	hold on
	hPlot=plot(tnose_x,tnose_y,ColorString);
	set(hPlot,'LineWidth',LineWidth)
	axis([0 1 0 1])
	axis('off')
	hold on
	if status==2
		hPlot=plot(scalp_x(1:29),scalp_y(1:29),ColorString);
		set(hPlot,'LineWidth',LineWidth)
		hold on
		hPlot=plot(scalp_x(32:40),scalp_y(32:40),ColorString);
		set(hPlot,'LineWidth',LineWidth)
		axis('off')
		hold on
	end


elseif chSpecView==5

	hPlot=plot(rn_x,n_y,ColorString);
	set(hPlot,'LineWidth',LineWidth)
	axis([0 1 0 1])
	axis('off')
	hPlot=plot(lnose_x,nose_y,ColorString);
	set(hPlot,'LineWidth',LineWidth)
	axis([0 1 0 1])
	axis('off')
	if status==2
		hPlot=plot(scalp_x(18:40),scalp_y(18:40),ColorString);
		set(hPlot,'LineWidth',LineWidth)
		hold on
		hPlot=plot(scalp_x(1:2),scalp_y(1:2),ColorString);
		set(hPlot,'LineWidth',LineWidth)
		axis('off')
		hold on
	end

elseif chSpecView==6

	hPlot=plot(ln_x,n_y,ColorString);
	set(hPlot,'LineWidth',LineWidth)
	axis([0 1 0 1])
	axis('off')
	hPlot=plot(rnose_x,nose_y,ColorString);
	set(hPlot,'LineWidth',LineWidth)
	axis([0 1 0 1])
	axis('off')
	if status==2
		hPlot=plot(scalp_x(19:40),scalp_y(19:40),ColorString);
		set(hPlot,'LineWidth',LineWidth)
		hold on
		hPlot=plot(scalp_x(1:4),scalp_y(1:4),ColorString);
		set(hPlot,'LineWidth',LineWidth)
		axis('off')
		hold on
	end
end
axis('off')
return;
