function [data] = read_hist_data( fid, nsmp, ncol )

%   read_hist_data

 %   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                     

frewind (fid);

filename = read_hist_header (fid);

if ncol == 5
  for k=1:nsmp
    data(k,:) = fscanf(fid,'%f',[1,5]);
  end;  
elseif ncol == 9
  for k=1:nsmp
    data(k,:) = fscanf(fid,'%f',[1,9]);
  end;  
else
  error('Check for number of columns in read_hist_data.m and data-File')
end
  
