function [filename, NOB, XMAX,YMAX,ZMAX, 
          xmin, xmax, ymin, ymax, zmin, zmax, divisions, nop, not, si, ncol, 
          axisdata] = read_hist_header( fid )
          
%   read_hist_header
          
%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      

%**********************************
%   reading header
%**********************************
frewind (fid);
filename=fgetl(fid);
NOB=fgetl(fid); 
XMAX=fgetl(fid); 
YMAX=fgetl(fid); 
ZMAX=fgetl(fid); 

%NOB=sscanf(line,'%s %s %s %s',1);
%NOP=fscanf(line,'%s',1);
%NOT=fscanf(line,'%s',1);
%SI =fscanf(line,'%s',1);
%XMAX=fscanf(line,'%s',1);
%XMIN=fscanf(line,'%s',1);
%YMAX=fscanf(line,'%s',1);
%YMIN=fscanf(line,'%s',1);
%ZMAX=fscanf(line,'%s',1);
%ZMIN=fscanf(line,'%s',1);

%**********************************
%   read array boundaries
%**********************************
line=fgetl(fid); xmax=sscanf(line,'%f',1);
line=fgetl(fid); xmin=sscanf(line,'%f',1);
line=fgetl(fid); ymax=sscanf(line,'%f',1);
line=fgetl(fid); ymin=sscanf(line,'%f',1);
line=fgetl(fid); zmax=sscanf(line,'%f',1);
line=fgetl(fid); zmin=sscanf(line,'%f',1);

line=fgetl(fid);
[div,nod] = sscanf(line,'%i %i %i %f',4);
if nod == 1 
 divisions = div(1);
 nop = -1;
 not = -1;
 si =  -9999.9999;
 ncol = 5;
elseif nod == 4
 divisions = div(1);
 nop = div(2);
 not = div(3);
 si  = div(4);
 ncol = 9;
end;

fprintf('Nsample = %d \n', divisions);

%*************************************
% read axis division values
%*************************************

for k=1:divisions
  line=fgetl(fid);
  x = sscanf(line,'%f %f %f',3);
  axisdata(k,:) = transpose(x);
end;  
