function uirmanova(action)

%   uirmanova

%   This software is protected by german copyright and international treaties.             
%   Copyright 2004 Markus Junghfer & Peter Peyk. All Rights Reserved.                     
%                                                                                          
%   THIS SOFTWARE AND DOCUMENTATION IS PROVIDED "AS IS," AND COPYRIGHT HOLDERS MAKE        
%   NO REPRESENTATIONS OR WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO,    
%   WARRANTIES OF MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR PURPOSE OR THAT THE USE    
%   OF THE SOFTWARE OR DOCUMENTATION WILL NOT INFRINGE ANY THIRD PARTY PATENTS, COPYRIGHTS,
%   TRADEMARKS OR OTHER RIGHTS. COPYRIGHT HOLDERS WILL NOT BE LIABLE FOR ANY DIRECT,       
%   INDIRECT, SPECIAL OR CONSEQUENTIAL DAMAGES ARISING OUT OF ANY USE OF THE SOFTWARE      
%   OR DOCUMENTATION.                                                                      


if nargin<1
    uigettext('Enter design in the box below and press ''ok'':',['factor1: nrofgradations; grad1,grad2;';'factor2: nrofgradations; grad1,grad2;'],'nonmodal',2)
    

%=============================================
%=============================================
elseif strcmp(action,'design')
    
    editfenster = findobj('tag','editfenster');
    designstring = get(editfenster,'string');
    
	if isempty(designstring)
        return
	else
        uigettextfigure = findobj('tag','uigettextfigure');
        hanovadata = findobj('tag','hanovadata');
		hfactor = findobj('tag','hfactor');
		hfactorp2d = findobj('tag','hfactorp2d');
		hresults = findobj('tag','hresults');
	end
	nrofrows = size(designstring,1);
	
	%factors(cell): vert: one factor per row;  horz: 1:name; 2:nrofgradations; 3:gradationtitles;
	factor = cell(1);
	
	
	for row = 1:nrofrows
        
        %structure data
        actualline = designstring(row,:);
        commata = findstr(actualline,',');
        semicolon = findstr(actualline,';');
        colon = findstr(actualline,':');
        if length(colon)>2
            uiwait(errordlg({['Syntax error in line ',num2str(row),': only 1 '':'' per line is permitted!']},'Syntax error:'));
            return
        end
        if length(semicolon)>3
            uiwait(errordlg({['Syntax error in line ',num2str(row),': only 2 '';'' per line are permitted!']},'Syntax error:'));
            return
        end
        if isempty(semicolon) & ~isempty(actualline)
            uiwait(errordlg({['Syntax error in line ',num2str(row),':  '';'' expected!']},'Syntax error:'));
            return
        end
        
        %factor1
        if row ==1
            factor{1,1} = designstring(row,1:findstr(actualline,':')-1);
            %nrofgradations:
            factor{1,2}= str2num(designstring(row,findstr(actualline,':')+1:semicolon(1)));
            if ~isempty(commata) & length(semicolon)==2
                
                factor{1,3}{1}=designstring(row,semicolon(1)+1:commata(1)-1);
                for t=1:length(commata)-1
                    factor{row-2,3}{t+1}=designstring(row,commata(t)+1:commata(t+1)-1);
                end
                factor{1,3}{length(commata)+1}=designstring(row,commata(end)+1:semicolon(2)-1);
            else
                factor{1,3}=[];
            end
        end   
        
        %factor2
        if row == 2
            factor{2,1} = designstring(row,1:findstr(actualline,':')-1);
            %nrofgradations:
            factor{2,2}= str2num(designstring(row,findstr(actualline,':')+1:semicolon(1)));
            if ~isempty(commata) & length(semicolon)==2
                
                factor{2,3}{1}=designstring(row,semicolon(1)+1:commata(1)-1);
                for t=1:length(commata)-1
                    factor{row-2,3}{t+1}=designstring(row,commata(t)+1:commata(t+1)-1);
                end
                factor{2,3}{length(commata)+1}=designstring(row,commata(end)+1:semicolon(2)-1);
            else
                factor{2,3}=[];
            end
        end
        
        %factor3
        if row == 3
              factor{3,1} = designstring(row,1:findstr(actualline,':')-1);
            %nrofgradations:
            factor{3,2}= str2num(designstring(row,findstr(actualline,':')+1:semicolon(1)));
            if ~isempty(commata) & length(semicolon)==2
                
                factor{3,3}{1}=designstring(row,semicolon(1)+1:commata(1)-1);
                for t=1:length(commata)-1
                    factor{3,3}{t+1}=designstring(row,commata(t)+1:commata(t+1)-1);
                end
                factor{3,3}{length(commata)+1}=designstring(row,commata(end)+1:semicolon(2)-1);
            else
                factor{3,3}=[];
            end
        end
        
        %factor4
        if row == 4
              factor{4,1} = designstring(row,1:findstr(actualline,':')-1);
            %nrofgradations:
            factor{4,2}= str2num(designstring(row,findstr(actualline,':')+1:semicolon(1)));
            if ~isempty(commata) & length(semicolon)==2
                
                factor{4,3}{1}=designstring(row,semicolon(1)+1:commata(1)-1);
                for t=1:length(commata)-1
                    factor{4,3}{t+1}=designstring(row,commata(t)+1:commata(t+1)-1);
                end
                factor{4,3}{length(commata)+1}=designstring(row,commata(end)+1:semicolon(2)-1);
            else
                factor{4,3}=[];
            end    
        end
	end
	message = 'Design successfully set!';
    uiwait(msgbox(message,'Desig input:'));
	set(hfactor,'userdata',factor);
    return
    
    
%=============================================
%=============================================

elseif strcmp(action,'run')
   
  
    
    uigettextfigure = findobj('tag','uigettextfigure');
    hanovadata = findobj('tag','hanovadata');
	hfactor = findobj('tag','hfactor');
	hfactorp2d = findobj('tag','hfactorp2d');
	hresults = findobj('tag','hresults');
    
    factor = get(hfactor,'userdata');
    anovadata = get(hanovadata,'userdata');
	subjects = size(anovadata,1);
	nroffactors = size(factor,1);
	customgradations = 1;
        
	for j=1:nroffactors
        customgradations = customgradations*factor{j,2};
	end
          
    if isempty(anovadata)
        uiwait(errordlg('There was an error using the imported data... Perhaps no data was imported, or the designstring does not correspond the datamatrix!'));
        results = [];
    end
	if size(anovadata,2)~=customgradations
        errordlg('Number of cells does not match the product of factor gradations! Quitting...','Factorial design:');
        return
	end
    
    
    if nroffactors > 0
        factor1nrofgradations = factor{1,2};
    else
        factor1nrofgradations = 1;
    end
    if nroffactors > 1
        factor2nrofgradations = factor{2,2};
    else
        factor2nrofgradations = 1;
    end
    if nroffactors > 2
        factor3nrofgradations = factor{3,2};
    else
        factor3nrofgradations = 1;
    end
    if nroffactors > 3 
        factor4nrofgradations = factor{4,2};
    else
        factor4nrofgradations = 1;
    end
    
    repeatfactor1 = 1
    repeatfactor2 = factor1nrofgradations;
    repeatfactor3 = factor1nrofgradations*factor2nrofgradations; 
    repeatfactor4 = factor1nrofgradations*factor2nrofgradations*factor3nrofgradations;
	
    
    validfactors = cell(1);
    nrofvalidfactors = 0;
    
	%totmean,QS & df
	%--------------------------
	TotMean = mean(mean(anovadata));
	TotDf = prod(size(squeeze(anovadata)))-1;
	
	%subjectmean,QS & df (between)
	%--------------------------
	SubjectMean = mean(anovadata,2);
    if size(anovadata,2)>1
		SubjectQS=0;
        for k=1:size(anovadata,1)
            %SubjectQS=SubjectQS+size(anovadata,2)*((SubjectMean(k)-TotMean)^2);
            SubjectQS = SubjectQS + size(anovadata,2)*(SubjectMean(k)-TotMean)^2;
        end
        
		SubjectsDf = subjects-1;
    else
        uiwait(errordlg('Cannot calculate repeated measures ANOVA with less than 2 subjects!','Error:'));
        return
    end
        
	%cellmean,QS & df
	%--------------------------
	CellMean = mean(anovadata,1);
	
     %factor 1
     %--------------
    if nroffactors > 0
       factor1nrofgradations = factor{1,2};
       if factor1nrofgradations>1
            nrofvalidfactors = nrofvalidfactors +1;
            validfactor{nrofvalidfactors,1}=factor{1,1};
            validfactor{nrofvalidfactors,2}=factor{1,2};
            validfactor{nrofvalidfactors,3}=factor{1,3};
        end
    else
        factor1nrofgradations = 1;    
    end
    
     %factor 2
    %--------------
    if nroffactors > 1
        factor2nrofgradations = factor{2,2};
        if factor2nrofgradations>1
            nrofvalidfactors = nrofvalidfactors +1;
            validfactor{nrofvalidfactors,1}=factor{2,1};
            validfactor{nrofvalidfactors,2}=factor{2,2};
            validfactor{nrofvalidfactors,3}=factor{2,3};
        end
    else
        factor2nrofgradations = 1;
    end
    
    %factor 3
    %--------------
    if nroffactors > 2
        factor3nrofgradations = factor{3,2};
        if factor3nrofgradations>1
            nrofvalidfactors = nrofvalidfactors +1;
            validfactor{nrofvalidfactors,1}=factor{3,1};
            validfactor{nrofvalidfactors,2}=factor{3,2};
            validfactor{nrofvalidfactors,3}=factor{3,3};
        end
    else
        factor3nrofgradations = 1;
    end
   
    %factor 4
    %--------------
    if nroffactors > 3 
        factor4nrofgradations = factor{4,2};
        if factor4nrofgradations>1
            nrofvalidfactors = nrofvalidfactors +1;
            validfactor{nrofvalidfactors,1}=factor{4,1};
            validfactor{nrofvalidfactors,2}=factor{4,2};
            validfactor{nrofvalidfactors,3}=factor{4,3};
        end
    else
        factor4nrofgradations=1;
    end
    
        
        
    if nrofvalidfactors>1
        results = cell(1,2);
        results{2,1}='Two-way Interactions';
        results{2,2}= [];
    end
    if nrofvalidfactors>2
        results{3,1}='Three-way Interactions';
        results{3,2}= [];
    end
    if nrofvalidfactors>3
        results{4,1}='Four-way Interactions';
        results{4,2}= [];
    end    
    
      
    %Calculate Sum-Squares (SS)
    %------------------------------
    
    TotKZ = (TotMean^2)/prod(size(anovadata));
    %totmean,QS & df
	%--------------------------
	TotMean = mean(mean(anovadata));
	TotQS = 0;
	for i=1:size(anovadata,1)
        for j=1:size(anovadata,2)
            TotQS=TotQS+((anovadata(i,j)-TotMean)^2);
        end
	end
	TotDf = prod(size(squeeze(anovadata))-1);

    SubjectKZ = sum((mean(anovadata,2)).^2)/size(anovadata,2);
    
    
    
    %create and save plotstringcell for later plotting
    %-------------------------------
	plotstringcell=cell(1);
	%maineffects
	for i=1:size(validfactor,1)
        plotstringcell{i,1} = validfactor{i,1};
        plotstringcell{i,2} = i;
        plotstringcell{i,3} = validfactor{i,2};
	end
	%interactions
	zaehler = i+1;
	for i=2:size(validfactor,1)
        interactions = nchoosek(1:size(validfactor,1),i);
        for t=1:size(interactions,1)
            
            label = validfactor{interactions(t,1),1};
            nrofcells = validfactor{interactions(t,1),2};
            for s=2:i
                label = [label,'X',validfactor{interactions(t,s),1}];
                nrofcells = nrofcells * validfactor{interactions(t,s),2};
            end
            plotstringcell{zaehler,1} = label;
            plotstringcell{zaehler,2} = interactions(t,:);
            plotstringcell{zaehler,3} = nrofcells;
            zaehler = zaehler +1;
        end
	end
	uirmanovafilepath= which('uirmanova.m');
	uirmanovafilepath(findstr(uirmanovafilepath,'uirmanova.m'):findstr(uirmanovafilepath,'uirmanova.m')+10)=[];
	file= [uirmanovafilepath,'rmanovautil.mat'];
	save(file,'plotstringcell');



    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%                  Haupteffekte                    %%%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    
    
    results{1,1}='main effects';
    resultstmp = results;
    resultstmp{1,2}=calc_rm_anova(anovadata,validfactor,1)
        
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    %%%%                  Interaktionen                   %%%%
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
   
    
    for r=2:nrofvalidfactors
        tmpdata=calc_rm_anova(anovadata,validfactor,r);
        if isempty(tmpdata)
            resultstmp=[];
            return
        else
            resultstmp{r,2} = tmpdata;
        end
    end
    results=resultstmp;
    
    
    %Modify Sum-Squares Error-Sum-Squares, Error-MS and calculate F- and p-Value:
    %-----------------------------------------------------------------
    %   When using grouping factors, ErrorQS will have to be modified
    %   again....(Winer(1971,pp. 548)
    
    
    %1:Name 2:ConditionQS(SS) 3:ConditionDf 4:ConditionMeanSquare(MS) 5:ErrorQS 6:ErrorDf 7:ErrorMeanSquare(MS)...
    %8:F-Value 9:p-Value
    
   
    %main-effects
    for r=1:nrofvalidfactors
        %Error-SS
        results{1,2}{r,5} = results{1,2}{r,5}-SubjectQS;
        %Subtract Main-Effect from Error-SS
        results{1,2}{r,5} = results{1,2}{r,5}-results{1,2}{r,2};
        %Error-MS
        results{1,2}{r,7} = results{1,2}{r,5} / results{1,2}{r,6};
        %F-Value
        results{1,2}{r,8}=  results{1,2}{r,4} / results{1,2}{r,7};
        %p-Value
        results{1,2}{r,9}=  1- fcdf(results{1,2}{r,8},results{1,2}{r,3},results{1,2}{r,6}); 
        %p-Value(gg)
        if results{1,2}{r,3}<2 | results{1,2}{r,6}<2
            results{1,2}{r,12} = results{1,2}{r,9};
        else
            results{1,2}{r,12}=  1- fcdf(results{1,2}{r,8},results{1,2}{r,3}*results{1,2}{r,10},results{1,2}{r,6}*results{1,2}{r,10}); 
        end
        %p-Value(huynh-feldt)
        if results{1,2}{r,3}<2 | results{1,2}{r,6}<2
            results{1,2}{r,13} = results{1,2}{r,9};
        else
            results{1,2}{r,13}=  1- fcdf(results{1,2}{r,8},results{1,2}{r,3}*results{1,2}{r,11},results{1,2}{r,6}*results{1,2}{r,11}); 
        end
    end
    
    %interactions
    for r=2:nrofvalidfactors %counts up interaction-type
        for s=1:size(results{r,2},1) %counts up combinations of factors for r-way-interaction
            
            %Subtract main-effects-SS
            for e=1:size(results{r,2}{s,1},2)
                %main-effect-QS from interaction-effect-QS
                fprintf(['Subtracting ',strrep(num2str(results{r,2}{s,1}(e)),'  ','-'),'-main-effect-QS from ',strrep(num2str(results{r,2}{s,1}),'  ','-'),'-interaction-effect-QS:\n']);
                results{r,2}{s,2}=results{r,2}{s,2}-results{1,2}{results{r,2}{s,1}(e),2};
                %QS =  results{r,2}{s,2}
                %and main-effect-error-QS from error-QS
                fprintf(['Subtracting ',strrep(num2str(results{r,2}{s,1}(e)),'  ','-'),'-main-effect-error-QS from ',strrep(num2str(results{r,2}{s,1}),'  ','-'),'-interaction-error-QS:\n']);
                results{r,2}{s,5}=results{r,2}{s,5}-results{1,2}{results{r,2}{s,1}(e),5};
                %QS =  results{r,2}{s,5}
                %and main-effect-QS from interaction-error-QS
                fprintf(['Subtracting ',strrep(num2str(results{r,2}{s,1}(e)),'  ','-'),'-main-effect-QS from ',strrep(num2str(results{r,2}{s,1}),'  ','-'),'-interaction-error-QS:\n']);
                results{r,2}{s,5}=results{r,2}{s,5}-results{1,2}{results{r,2}{s,1}(e),2};
                %QS =  results{r,2}{s,5}
            end
             
           
            %subtract lower order interaction-SS
            for f=r-1:-1:2 %f counts down the interaction-types
                
                for q=1:size(results{f,2},1) %q counts up combinations of factors for f-way-interaction
                    matchzaehler = 0;
                    
                    %find relevant lower order interactions
                    for v=1:size(results{f,2}{q,1},2) %v counts across numbers designating interaction type
                        if ~isempty(find(results{f,2}{q,1}(v)==results{r,2}{s,1}))
                            matchzaehler = matchzaehler+1;
                        end
                    end
                    if matchzaehler == f
                        
                        %subtract interaction-SS from condition-QS
                        fprintf(['Subtracting ',strrep(num2str(results{f,2}{q,1}),'  ','-'),'-interaction-effect-QS from ',strrep(num2str(results{r,2}{s,1}),'  ','-'),'-interaction-effect-QS:\n']);
                        results{r,2}{s,2}=results{r,2}{s,2}-results{f,2}{q,2};
                        %QS =  results{r,2}{s,2}
                        
                        %subtract interaction-SS from error-QS
                        fprintf(['Subtracting ',strrep(num2str(results{f,2}{q,1}),'  ','-'),'-interaction-effect-QS from ',strrep(num2str(results{r,2}{s,1}),'  ','-'),'-interaction-error-QS:\n']);
                        results{r,2}{s,5}=results{r,2}{s,5}-results{f,2}{q,2};
                        %QS =  results{r,2}{s,5}
                        
                        %and its error-QS from error-QS
                        fprintf(['Subtracting ',strrep(num2str(results{f,2}{q,1}),'  ','-'),'-interaction-error-QS from ',strrep(num2str(results{r,2}{s,1}),'  ','-'),'-interaction-error-QS:\n']);
                        results{r,2}{s,5}=results{r,2}{s,5}-results{f,2}{q,5};
                        %QS =  results{r,2}{s,5}
                    end
                end
            end
            
            %subtract interaction from error-QS 
            fprintf(['Subtracting ',strrep(num2str(results{r,2}{s,1}),'  ','-'),'-interaction-effect-QS from ',strrep(num2str(results{r,2}{s,1}),'  ','-'),'-interaction-error-QS:\n']);
            results{r,2}{s,5}=results{r,2}{s,5}-results{r,2}{s,2};
            %QS =  results{r,2}{s,5}
            
            %subtract subject-QS from Error-SS 
            fprintf(['Subtracting ','Subject-QS from ',strrep(num2str(results{r,2}{s,1}),'  ','-'),'-interaction-error-QS:\n']);
            results{r,2}{s,5}=results{r,2}{s,5}-SubjectQS;
            %QS =  results{r,2}{s,5}
            
            
            %Condition-MS
            results{r,2}{s,4} = results{r,2}{s,2} / results{r,2}{s,3};
            %Error-MS
            results{r,2}{s,7} = results{r,2}{s,5} / results{r,2}{s,6};
            %F-Value
            results{r,2}{s,8}=  results{r,2}{s,4} / results{r,2}{s,7};
            %p-Value
            results{r,2}{s,9}=  1- fcdf(results{r,2}{s,8},results{r,2}{s,3},results{r,2}{s,6}); 
            %p-Value(greenhouse & geisser)
            results{r,2}{s,12}=  1- fcdf(results{r,2}{s,8},results{r,2}{s,3}*results{r,2}{s,10},results{r,2}{s,6}*results{r,2}{s,10}); 
            %p-Value(huynh-feldth)
            results{r,2}{s,13}=  1- fcdf(results{r,2}{s,8},results{r,2}{s,3}*results{r,2}{s,11},results{r,2}{s,6}*results{r,2}{s,11}); 
        end
    end
    
   
    
    
    %Write report
    %----------------
    formatstring = '%7.3f';
    
    rowzaehler =1;
    
     %TotQS
    outstring{rowzaehler,1} = ['Total: '];
    rowzaehler = rowzaehler+1;
    outstring{rowzaehler,1} = '----------------------------';
    rowzaehler = rowzaehler+1;
    outstring{rowzaehler,1} = ['TotalQS: ',num2str(TotQS,formatstring),'; TotalDf: ',num2str(TotDf),';'];
    rowzaehler = rowzaehler+1;outstring{rowzaehler,1}='';
    rowzaehler = rowzaehler+1;
    
    
    %SubjectsQS
    outstring{rowzaehler,1} = ['Subjects: '];
    rowzaehler = rowzaehler+1;
    outstring{rowzaehler,1} = '----------------------------';
    rowzaehler = rowzaehler+1;
    outstring{rowzaehler,1} = ['SubjectsQS: ',num2str(SubjectQS,formatstring),'; SubjectDf: ',num2str(SubjectsDf),';'];
    rowzaehler = rowzaehler+1;outstring{rowzaehler,1}='';
    rowzaehler = rowzaehler+1;
    
    %Main Effects
    outstring{rowzaehler,1} = 'Main Effects:';
    rowzaehler = rowzaehler+1;
    outstring{rowzaehler,1} = '----------------------------';
    rowzaehler = rowzaehler+1;
    
    
    for v=1:nrofvalidfactors
         outstring{rowzaehler,1}=[validfactor{v,1},': ConditionQS: ',num2str(results{1,2}{v,2},formatstring),...
                 ': ConditionMQS: ',num2str(results{1,2}{v,4},formatstring),'; ErrorQS: ',num2str(results{1,2}{v,5},formatstring),...
                 ': ErrorMQS: ',num2str(results{1,2}{v,7},formatstring),'; p = ',num2str(results{1,2}{v,9},formatstring),...
                 '; epsilon_gg = ',num2str(results{1,2}{v,10},formatstring),'; epsilon_hf = ',num2str(results{1,2}{v,11},formatstring),...
                 '; F(',num2str(results{1,2}{v,3}),',',num2str(results{1,2}{v,6}),...
                 ')=',num2str(results{1,2}{v,8},formatstring),'; p(gg) = ',num2str(results{1,2}{v,12},formatstring),...
                 '; p(hf) = ',num2str(results{1,2}{v,13},formatstring),';'];
         rowzaehler = rowzaehler+1;
    end
   
    outstring{rowzaehler,1}='';
    rowzaehler = rowzaehler+1;
    
    
    %interactions
    for w=2:size(results,1)
        
        outstring{rowzaehler,1}=[results{w,1},':'];
        rowzaehler = rowzaehler + 1;
        outstring{rowzaehler,1}='----------------------------';
        rowzaehler = rowzaehler + 1;
        
        for v=1:size(results{w,2},1)
            outstring{rowzaehler,1}='';
            outstring{rowzaehler,1}=[outstring{rowzaehler,1} validfactor{results{w,2}{v,1}(1),1}];
            
            for t=2:size(results{w,2}{1},2)
                outstring{rowzaehler,1}=[outstring{rowzaehler,1} ' x ' validfactor{results{w,2}{v,1}(t),1}];
            end
         
            outstring{rowzaehler,1}=[outstring{rowzaehler,1},': ConditionQS: ',num2str(results{w,2}{v,2},formatstring),...
                    '; ConditionMQS: ',num2str(results{w,2}{v,4},formatstring),'; ErrorQS: ',num2str(results{w,2}{v,5},formatstring),...
                    '; ErrorMQS: ',num2str(results{w,2}{v,7},formatstring),'; p = ',num2str(results{w,2}{v,9},formatstring),...
                    '; epsilon_gg = ',num2str(results{w,2}{v,10},formatstring),'; epsilon_hf = ',num2str(results{w,2}{v,11},formatstring),...
                    '; F(',num2str(results{w,2}{v,3}),',',num2str(results{w,2}{v,6}),...
                    ')=',num2str(results{w,2}{v,8},formatstring),'; p(gg) = ',num2str(results{w,2}{v,12},formatstring),...
                    '; p(hf) = ',num2str(results{w,2}{v,13},formatstring),';'];
        
            rowzaehler = rowzaehler + 1;
        end
        outstring{rowzaehler,1}='';
        rowzaehler = rowzaehler + 1;
    end
   
    close(uigettextfigure);
    uigettext('Results:',outstring,'nomodal',2);
    
    hfactor = findobj('tag','hfactor');
    set(hfactor,'userdata',validfactor);
    set(findobj('tag','hanovadata'),'Userdata',anovadata);
    set(findobj('tag','hfactor'),'userdata',factor);
    set(findobj('tag','hresults'),'userdata',results);
    
return
    
    
end



                
                
return